/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.method;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.everrest.core.ApplicationContext;
import org.everrest.core.FilterDescriptor;
import org.everrest.core.ObjectFactory;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.method.ParameterResolver;
import org.everrest.core.impl.method.ParameterResolverFactory;
import org.everrest.core.method.MethodInvoker;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.method.MethodParameter;
import org.everrest.core.resource.GenericMethodResource;
import org.everrest.core.util.Logger;

public class DefaultMethodInvoker
implements MethodInvoker {
    private static final Logger LOG = Logger.getLogger(DefaultMethodInvoker.class);

    @Override
    public final Object invokeMethod(Object resource, GenericMethodResource methodResource, ApplicationContext context) {
        this.beforeInvokeMethod(methodResource, methodResource, context);
        Object[] p = new Object[methodResource.getMethodParameters().size()];
        int i = 0;
        for (MethodParameter mp : methodResource.getMethodParameters()) {
            Annotation a = mp.getAnnotation();
            if (a != null) {
                ParameterResolver pr = ParameterResolverFactory.createParameterResolver(a);
                try {
                    p[i++] = pr.resolve(mp, context);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Not able resolve method parameter " + mp;
                    Class<? extends Annotation> ac = a.annotationType();
                    if (ac == MatrixParam.class || ac == QueryParam.class || ac == PathParam.class) {
                        throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg).type("text/plain").build());
                    }
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).type("text/plain").build());
                }
            }
            InputStream entityStream = context.getContainerRequest().getEntityStream();
            if (entityStream == null) {
                p[i++] = null;
                continue;
            }
            MediaType contentType = context.getContainerRequest().getMediaType();
            MessageBodyReader<?> entityReader = context.getProviders().getMessageBodyReader(mp.getParameterClass(), mp.getGenericType(), mp.getAnnotations(), contentType);
            if (entityReader == null) {
                List contentLength = context.getContainerRequest().getRequestHeader("Content-Length");
                int length = 0;
                if (contentLength != null && contentLength.size() > 0) {
                    try {
                        length = Integer.parseInt((String)contentLength.get(0));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (contentType == null && length == 0) {
                    p[i++] = null;
                    continue;
                }
                String msg = "Media type " + contentType + " is not supported. There is no corresponded entity reader.";
                if (LOG.isDebugEnabled()) {
                    LOG.warn(msg);
                }
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)msg).type("text/plain").build());
            }
            try {
                MultivaluedMap headers = context.getContainerRequest().getRequestHeaders();
                p[i++] = entityReader.readFrom(mp.getParameterClass(), mp.getGenericType(), mp.getAnnotations(), contentType, headers, entityStream);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    e.printStackTrace();
                }
                if (e instanceof WebApplicationException) {
                    throw (WebApplicationException)e;
                }
                throw new InternalException(e);
            }
        }
        return this.invokeMethod(resource, methodResource, p);
    }

    protected void beforeInvokeMethod(Object resource, GenericMethodResource methodResource, ApplicationContext context) {
        for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getMethodInvokerFilters(context.getPath())) {
            MethodInvokerFilter f = (MethodInvokerFilter)factory.getInstance(context);
            f.accept(methodResource);
        }
    }

    protected Object invokeMethod(Object resource, GenericMethodResource methodResource, Object[] p) {
        try {
            return methodResource.getMethod().invoke(resource, p);
        }
        catch (IllegalArgumentException argExc) {
            throw new InternalException(argExc);
        }
        catch (IllegalAccessException accessExc) {
            throw new InternalException(accessExc);
        }
        catch (InvocationTargetException invExc) {
            Throwable cause;
            if (LOG.isDebugEnabled()) {
                invExc.printStackTrace();
            }
            if (WebApplicationException.class == (cause = invExc.getCause()).getClass()) {
                throw (WebApplicationException)cause;
            }
            throw new InternalException(cause);
        }
    }
}

