/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public final class IOHelper {
    static final String DEFAULT_CHARSET_NAME = "UTF-8";
    static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    private IOHelper() {
    }

    public static void write(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        int rd = -1;
        while ((rd = in.read(buf)) != -1) {
            out.write(buf, 0, rd);
        }
    }

    public static void write(Reader in, Writer out) throws IOException {
        char[] buf = new char[1024];
        int rd = -1;
        while ((rd = in.read(buf)) != -1) {
            out.write(buf, 0, rd);
        }
    }

    public static String readString(InputStream in, String cs) throws IOException {
        Charset charset;
        try {
            charset = cs != null ? Charset.forName(cs) : DEFAULT_CHARSET;
        }
        catch (Exception e) {
            charset = DEFAULT_CHARSET;
        }
        InputStreamReader r = new InputStreamReader(in, charset);
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        int rd = -1;
        while ((rd = r.read(buf)) != -1) {
            sb.append(buf, 0, rd);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(String s, OutputStream out, String cs) throws IOException {
        Charset charset;
        try {
            charset = cs != null ? Charset.forName(cs) : DEFAULT_CHARSET;
        }
        catch (Exception e) {
            charset = DEFAULT_CHARSET;
        }
        OutputStreamWriter w = new OutputStreamWriter(out, charset);
        try {
            w.write(s);
        }
        finally {
            ((Writer)w).flush();
        }
    }
}

