/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.everrest.core.method.MethodParameter;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.resource.ResourceMethodDescriptor;

public class ResourceMethodDescriptorImpl
implements ResourceMethodDescriptor {
    private final Method method;
    private final String httpMethod;
    private final List<MethodParameter> parameters;
    private final AbstractResourceDescriptor parentResource;
    private final List<MediaType> consumes;
    private final List<MediaType> produces;
    private final Annotation[] additional;

    ResourceMethodDescriptorImpl(Method method, String httpMethod, List<MethodParameter> parameters, AbstractResourceDescriptor parentResource, List<MediaType> consumes, List<MediaType> produces, Annotation[] additional) {
        this.method = method;
        this.httpMethod = httpMethod;
        this.parameters = parameters;
        this.parentResource = parentResource;
        this.consumes = consumes;
        this.produces = produces;
        this.additional = additional;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public List<MethodParameter> getMethodParameters() {
        return this.parameters;
    }

    @Override
    public AbstractResourceDescriptor getParentResource() {
        return this.parentResource;
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitResourceMethodDescriptor(this);
    }

    @Override
    public List<MediaType> consumes() {
        return this.consumes;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public List<MediaType> produces() {
        return this.produces;
    }

    @Override
    public Class<?> getResponseType() {
        return this.getMethod().getReturnType();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.additional;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ ResourceMethodDescriptorImpl: ");
        sb.append("resource: " + this.getParentResource() + "; ").append("HTTP method: " + this.getHttpMethod() + "; ").append("produces media type: " + this.produces() + "; ").append("consumes media type: " + this.consumes() + "; ").append("return type: " + this.getResponseType()).append("] ]");
        return sb.toString();
    }
}

