/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.core.Application;
import org.everrest.core.DependencySupplier;
import org.everrest.core.ResourceBinder;
import org.everrest.core.impl.ApplicationProviderBinder;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.impl.ResourceBinderImpl;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.core.servlet.ServletContextDependencySupplier;

public class EverrestInitializedListener
implements ServletContextListener {
    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext sctx = event.getServletContext();
        EverrestServletContextInitializer initializer = new EverrestServletContextInitializer(sctx);
        Application application = initializer.getApplication();
        DependencySupplier dependencySupplier = (DependencySupplier)sctx.getAttribute(DependencySupplier.class.getName());
        if (dependencySupplier == null) {
            dependencySupplier = new ServletContextDependencySupplier(sctx);
        }
        EverrestConfiguration config = initializer.getConfiguration();
        ResourceBinderImpl resources = new ResourceBinderImpl();
        ApplicationProviderBinder providers = new ApplicationProviderBinder();
        EverrestProcessor processor = new EverrestProcessor(resources, providers, dependencySupplier, config, application);
        sctx.setAttribute(DependencySupplier.class.getName(), (Object)dependencySupplier);
        sctx.setAttribute(ResourceBinder.class.getName(), (Object)resources);
        sctx.setAttribute(ApplicationProviderBinder.class.getName(), (Object)providers);
        sctx.setAttribute(EverrestProcessor.class.getName(), (Object)processor);
    }
}

