/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.LifecycleComponent;

public final class AnnotatedLifecycleMethodStrategy
implements LifecycleComponent.LifecycleMethodStrategy {
    private static final MethodFilter POSTCONSTRUCT_METHOD_FILTER = new MethodFilter(PostConstruct.class);
    private static final MethodFilter PREDESTROY_METHOD_FILTER = new MethodFilter(PreDestroy.class);

    @Override
    public void invokeInitializeMethods(Object o) {
        this.doInvokeLifecycleMethods(o, POSTCONSTRUCT_METHOD_FILTER);
    }

    @Override
    public void invokeDestroyMethods(Object o) {
        this.doInvokeLifecycleMethods(o, PREDESTROY_METHOD_FILTER);
    }

    private void doInvokeLifecycleMethods(Object o, MethodFilter filter) {
        for (Class<?> cl = o.getClass(); cl != Object.class; cl = cl.getSuperclass()) {
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!filter.accept(method)) continue;
                try {
                    if (!Modifier.isPublic(method.getModifiers())) {
                        method.setAccessible(true);
                    }
                    method.invoke(o, new Object[0]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    new InternalException(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    new InternalException(e);
                    continue;
                }
                catch (SecurityException e) {
                    new InternalException(e);
                    continue;
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    throw new InternalException(t);
                }
            }
        }
    }

    private static class MethodFilter {
        private final Class<? extends Annotation> annotation;

        MethodFilter(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        boolean accept(Method m) {
            return m.isAnnotationPresent(this.annotation) && !Modifier.isStatic(m.getModifiers()) && m.getParameterTypes().length == 0 && (m.getReturnType() == Void.TYPE || m.getReturnType() == Void.class) && this.noCheckedException(m);
        }

        private boolean noCheckedException(Method m) {
            Class<?>[] exceptions = m.getExceptionTypes();
            if (exceptions.length > 0) {
                for (int i = 0; i < exceptions.length; ++i) {
                    if (RuntimeException.class.isAssignableFrom(exceptions[i])) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

