/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.async;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.everrest.core.resource.ResourceMethodDescriptor;

public class AsynchronousJob
extends FutureTask<Object> {
    private final String jobId;
    private final long expirationDate;
    private final ResourceMethodDescriptor method;

    protected AsynchronousJob(Callable<Object> callable, String jobId, long timeout, TimeUnit unit, ResourceMethodDescriptor method) {
        super(callable);
        this.jobId = jobId;
        this.expirationDate = System.currentTimeMillis() + unit.toMillis(timeout);
        this.method = method;
    }

    public String getJobId() {
        return this.jobId;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public ResourceMethodDescriptor getResourceMethod() {
        return this.method;
    }
}

