/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.async;

import java.util.concurrent.ExecutionException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.async.AsynchronousJobPool;

@Path(value="async/{job}")
public class AsynchronousJobService {
    @Context
    private Providers providers;

    @GET
    public Object get(@PathParam(value="job") String jobId, @Context UriInfo uriInfo, @Context Request request) {
        AsynchronousJobPool pool = this.getJobPool();
        AsynchronousJob async = pool.getJob(jobId);
        if (async == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Job " + jobId + " not found. ")).type("text/plain").build());
        }
        if (async.isDone()) {
            Object result;
            try {
                result = async.get();
            }
            catch (InterruptedException e) {
                throw new WebApplicationException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new WebApplicationException((Throwable)e);
            }
            finally {
                pool.removeJob(jobId, false);
            }
            if (result == null || result.getClass() == Void.TYPE || result.getClass() == Void.class) {
                return Response.noContent().build();
            }
            if (Response.class.isAssignableFrom(result.getClass())) {
                Response response = (Response)result;
                if (response.getMetadata().getFirst((Object)"Content-Type") == null && response.getEntity() != null) {
                    response.getMetadata().putSingle((Object)"Content-Type", (Object)((GenericContainerRequest)request).getAcceptableMediaType(async.getResourceMethod().produces()));
                }
                return response;
            }
            return Response.ok(result, (MediaType)((GenericContainerRequest)request).getAcceptableMediaType(async.getResourceMethod().produces())).build();
        }
        String jobUri = uriInfo.getRequestUri().toString();
        return Response.status((Response.Status)Response.Status.ACCEPTED).header("Location", (Object)jobUri).entity((Object)jobUri).type("text/plain").build();
    }

    @DELETE
    public void remove(@PathParam(value="job") String jobId) {
        AsynchronousJobPool jobPool = this.getJobPool();
        if (!jobPool.removeJob(jobId, true)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Job " + jobId + " not found. ")).type("text/plain").build());
        }
    }

    private AsynchronousJobPool getJobPool() {
        ContextResolver asynchJobsResolver;
        if (this.providers != null && (asynchJobsResolver = this.providers.getContextResolver(AsynchronousJobPool.class, null)) != null) {
            return (AsynchronousJobPool)asynchJobsResolver.getContext(null);
        }
        throw new RuntimeException("Asynchronous jobs feature is not configured properly. ");
    }
}

