/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.FileCollector;
import org.everrest.core.impl.provider.IOHelper;
import org.everrest.core.provider.EntityProvider;

@Provider
public class InputStreamEntityProvider
implements EntityProvider<InputStream> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == InputStream.class;
    }

    public InputStream readFrom(Class<InputStream> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        boolean async = Boolean.parseBoolean((String)context.getQueryParameters().getFirst((Object)"async"));
        if (async) {
            int r;
            int bufferSize = context.getProperties().get("ws.rs.buffersize") == null ? 204800 : Integer.parseInt((String)context.getProperties().get("ws.rs.buffersize"));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[8192];
            boolean overflow = false;
            while (!overflow && (r = entityStream.read(b)) != -1) {
                bos.write(b, 0, r);
                overflow = bos.size() > bufferSize;
            }
            if (overflow) {
                File f = FileCollector.getInstance().createFile();
                FileOutputStream fos = new FileOutputStream(f);
                bos.writeTo(fos);
                while ((r = entityStream.read(b)) != -1) {
                    fos.write(b, 0, r);
                }
                fos.close();
                return new DeleteOnCloseFIS(f);
            }
            return new ByteArrayInputStream(bos.toByteArray());
        }
        return entityStream;
    }

    public long getSize(InputStream t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return InputStream.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(InputStream t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            IOHelper.write(t, entityStream);
        }
        finally {
            t.close();
        }
    }

    private static final class DeleteOnCloseFIS
    extends FileInputStream {
        private final File file;

        public DeleteOnCloseFIS(File file) throws FileNotFoundException {
            super(file);
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.file.exists()) {
                    this.file.delete();
                }
            }
        }
    }
}

