/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonGenerator;
import org.everrest.core.impl.provider.json.JsonParser;
import org.everrest.core.impl.provider.json.JsonTransient;
import org.everrest.core.impl.provider.json.JsonUtils;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.impl.provider.json.JsonWriter;
import org.everrest.core.impl.provider.json.ObjectBuilder;
import org.everrest.core.provider.EntityProvider;
import org.everrest.core.util.Logger;

@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JsonEntityProvider<T>
implements EntityProvider<T> {
    private static final Logger LOG = Logger.getLogger(JsonEntityProvider.class);
    private static final Class<?>[] IGNORED = new Class[]{byte[].class, char[].class, DataSource.class, DOMSource.class, File.class, InputStream.class, OutputStream.class, JAXBElement.class, MultivaluedMap.class, Reader.class, Writer.class, SAXSource.class, StreamingOutput.class, StreamSource.class, String.class};

    private static boolean isIgnored(Class<?> type) {
        if (type.getAnnotation(JsonTransient.class) != null) {
            return true;
        }
        for (Class<?> c : IGNORED) {
            if (!c.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !JsonEntityProvider.isIgnored(type);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            JsonParser jsonParser = new JsonParser();
            jsonParser.parse(entityStream);
            JsonValue jsonValue = jsonParser.getJsonObject();
            if (JsonValue.class.isAssignableFrom(type)) {
                return (T)jsonValue;
            }
            JsonUtils.Types jtype = JsonUtils.getType(type);
            if (jtype == JsonUtils.Types.ARRAY_BOOLEAN || jtype == JsonUtils.Types.ARRAY_BYTE || jtype == JsonUtils.Types.ARRAY_SHORT || jtype == JsonUtils.Types.ARRAY_INT || jtype == JsonUtils.Types.ARRAY_LONG || jtype == JsonUtils.Types.ARRAY_FLOAT || jtype == JsonUtils.Types.ARRAY_DOUBLE || jtype == JsonUtils.Types.ARRAY_CHAR || jtype == JsonUtils.Types.ARRAY_STRING || jtype == JsonUtils.Types.ARRAY_OBJECT) {
                return (T)ObjectBuilder.createArray(type, jsonValue);
            }
            if (jtype == JsonUtils.Types.COLLECTION) {
                Class<T> c = type;
                return ObjectBuilder.createCollection(c, genericType, jsonValue);
            }
            if (jtype == JsonUtils.Types.MAP) {
                Class<T> c = type;
                return ObjectBuilder.createObject(c, genericType, jsonValue);
            }
            return ObjectBuilder.createObject(type, jsonValue);
        }
        catch (JsonException e) {
            LOG.error(e.getMessage(), e);
            throw new IOException("Can't read from input stream " + e);
        }
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !JsonEntityProvider.isIgnored(type);
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            JsonUtils.Types jtype;
            JsonValue jsonValue = null;
            jsonValue = t instanceof JsonValue ? (JsonValue)t : ((jtype = JsonUtils.getType(type)) == JsonUtils.Types.ARRAY_BOOLEAN || jtype == JsonUtils.Types.ARRAY_BYTE || jtype == JsonUtils.Types.ARRAY_SHORT || jtype == JsonUtils.Types.ARRAY_INT || jtype == JsonUtils.Types.ARRAY_LONG || jtype == JsonUtils.Types.ARRAY_FLOAT || jtype == JsonUtils.Types.ARRAY_DOUBLE || jtype == JsonUtils.Types.ARRAY_CHAR || jtype == JsonUtils.Types.ARRAY_STRING || jtype == JsonUtils.Types.ARRAY_OBJECT ? JsonGenerator.createJsonArray(t) : (jtype == JsonUtils.Types.COLLECTION ? JsonGenerator.createJsonArray((Collection)t) : (jtype == JsonUtils.Types.MAP ? JsonGenerator.createJsonObjectFromMap((Map)t) : JsonGenerator.createJsonObject(t))));
            JsonWriter jsonWriter = new JsonWriter(entityStream);
            jsonValue.writeTo(jsonWriter);
            jsonWriter.flush();
        }
        catch (JsonException e) {
            LOG.error(e.getMessage(), e);
            throw new IOException("Can't write to output stream. " + e.getMessage());
        }
    }
}

