/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.async.AsynchronousJobService;
import org.everrest.core.impl.method.filter.SecurityConstraint;

public final class EverrestApplication
extends Application {
    private final Set<Class<?>> classes = new LinkedHashSet(1);
    private final Set<Object> singletons = new LinkedHashSet<Object>(2);

    public EverrestApplication(EverrestConfiguration config) {
        if (config.isAsynchronousSupported()) {
            this.singletons.add(new AsynchronousJobPool(config));
            this.classes.add(AsynchronousJobService.class);
        }
        if (config.isCheckSecurity()) {
            this.singletons.add(new SecurityConstraint());
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public void addApplication(Application application) {
        if (application != null) {
            Set appClasses;
            Set appSingletons = application.getSingletons();
            if (appSingletons != null && appSingletons.size() > 0) {
                LinkedHashSet<Object> tmp = new LinkedHashSet<Object>(this.getSingletons().size() + appSingletons.size());
                tmp.addAll(appSingletons);
                tmp.addAll(this.getSingletons());
                this.getSingletons().clear();
                this.getSingletons().addAll(tmp);
            }
            if ((appClasses = application.getClasses()) != null && appClasses.size() > 0) {
                LinkedHashSet tmp = new LinkedHashSet(this.getClasses().size() + appClasses.size());
                tmp.addAll(appClasses);
                tmp.addAll(this.getClasses());
                this.getClasses().clear();
                this.getClasses().addAll(tmp);
            }
        }
    }
}

