/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class NoSyncByteArrayOutputStream
extends ByteArrayOutputStream {
    public NoSyncByteArrayOutputStream() {
        this(32);
    }

    public NoSyncByteArrayOutputStream(int size) {
        super(size);
    }

    public byte[] getBytes() {
        return this.buf;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    @Override
    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charsetName);
    }

    @Override
    public void write(byte[] b) {
        if (b.length == 0) {
            return;
        }
        int pos = this.count + b.length;
        if (pos > this.buf.length) {
            this.expand(Math.max(this.buf.length << 1, pos));
        }
        System.arraycopy(b, 0, this.buf, this.count, b.length);
        this.count = pos;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (len == 0) {
            return;
        }
        if (off < 0 || len < 0 || off > b.length || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int pos = this.count + len;
        if (pos > this.buf.length) {
            this.expand(Math.max(this.buf.length << 1, pos));
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = pos;
    }

    @Override
    public void write(int b) {
        int pos = this.count + 1;
        if (this.count >= this.buf.length) {
            this.expand(Math.max(this.buf.length << 1, pos));
        }
        this.buf[this.count] = (byte)b;
        this.count = pos;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    private void expand(int newsize) {
        byte[] newbuf = new byte[newsize];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        this.buf = newbuf;
    }
}

