/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.async;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.async.AsynchronousJobListener;
import org.everrest.core.impl.async.AsynchronousJobRejectedException;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.tools.EmptyInputStream;
import org.everrest.core.util.Logger;

@Provider
public class AsynchronousJobPool
implements ContextResolver<AsynchronousJobPool> {
    private static final Logger LOG = Logger.getLogger(AsynchronousJobPool.class);
    private static final AtomicLong jobIdGenerator = new AtomicLong(1L);
    private final int jobTimeout;
    private final int maxCacheSize;
    private final ExecutorService pool;
    private final Map<String, AsynchronousJob> jobs;
    private final CopyOnWriteArrayList<AsynchronousJobListener> jobListeners;

    private static String nextJobId() {
        return Long.toString(jobIdGenerator.getAndIncrement());
    }

    public AsynchronousJobPool(EverrestConfiguration config) {
        if (config == null) {
            config = new EverrestConfiguration();
        }
        this.maxCacheSize = config.getAsynchronousCacheSize();
        this.jobTimeout = config.getAsynchronousJobTimeout();
        int poolSize = config.getAsynchronousPoolSize();
        int queueSize = config.getAsynchronousQueueSize();
        this.pool = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ManyJobsPolicy(new ThreadPoolExecutor.AbortPolicy()));
        this.jobs = Collections.synchronizedMap(new LinkedHashMap<String, AsynchronousJob>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, AsynchronousJob> eldest) {
                AsynchronousJob job = eldest.getValue();
                if (this.size() > AsynchronousJobPool.this.maxCacheSize || job.getExpirationDate() < System.currentTimeMillis()) {
                    job.cancel();
                    return true;
                }
                return false;
            }
        });
        this.jobListeners = new CopyOnWriteArrayList();
    }

    public AsynchronousJobPool getContext(Class<?> type) {
        return this;
    }

    public AsynchronousJob addJob(Object resource, ResourceMethodDescriptor resourceMethod, Object[] params) throws AsynchronousJobRejectedException {
        AsynchronousFuture job = new AsynchronousFuture(AsynchronousJobPool.nextJobId(), this.newCallable(resource, resourceMethod.getMethod(), params), System.currentTimeMillis() + (long)(this.jobTimeout * 60 * 1000), resourceMethod);
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        GenericContainerRequest request = context.getContainerRequest();
        ContainerRequest copyRequest = new ContainerRequest(request.getMethod(), request.getRequestUri(), request.getBaseUri(), new EmptyInputStream(), (MultivaluedMap<String, String>)request.getRequestHeaders(), context.getSecurityContext());
        job.getContext().put("org.everrest.async.request", copyRequest);
        job.getContext().put("org.everrest.async.providers", context.getProviders());
        String jobId = job.getJobId();
        this.jobs.put(jobId, job);
        try {
            this.pool.execute(job);
        }
        catch (RejectedExecutionException e) {
            throw new AsynchronousJobRejectedException(e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add asynchronous job, ID " + jobId);
        }
        return job;
    }

    protected Callable<Object> newCallable(final Object resource, final Method method, final Object[] params) {
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return method.invoke(resource, params);
            }
        };
    }

    public AsynchronousJob getJob(String jobId) {
        return this.jobs.get(jobId);
    }

    public AsynchronousJob removeJob(String jobId) {
        AsynchronousJob job = this.jobs.remove(jobId);
        if (job != null && !job.isDone()) {
            job.cancel();
        }
        return job;
    }

    public List<AsynchronousJob> getAll() {
        Collection<AsynchronousJob> all = this.jobs.values();
        ArrayList<AsynchronousJob> copy = new ArrayList<AsynchronousJob>(all.size());
        copy.addAll(all);
        return copy;
    }

    public boolean registerListener(AsynchronousJobListener listener) {
        return this.jobListeners.addIfAbsent(listener);
    }

    public boolean unregisterListener(AsynchronousJobListener listener) {
        return this.jobListeners.remove(listener);
    }

    @PreDestroy
    public void stop() {
        this.pool.shutdown();
        try {
            if (!this.pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private class AsynchronousFuture
    extends FutureTask<Object>
    implements AsynchronousJob {
        private final String jobId;
        private final long expirationDate;
        private final ResourceMethodDescriptor method;
        private final Map<String, Object> context;

        protected AsynchronousFuture(String jobId, Callable<Object> callable, long expirationDate, ResourceMethodDescriptor method) {
            super(callable);
            this.jobId = jobId;
            this.expirationDate = expirationDate;
            this.method = method;
            this.context = new HashMap<String, Object>();
        }

        @Override
        protected void done() {
            for (AsynchronousJobListener l : AsynchronousJobPool.this.jobListeners) {
                l.done(this);
            }
        }

        @Override
        public String getJobId() {
            return this.jobId;
        }

        @Override
        public long getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public ResourceMethodDescriptor getResourceMethod() {
            return this.method;
        }

        @Override
        public boolean isDone() {
            return super.isDone();
        }

        @Override
        public boolean cancel() {
            return super.cancel(true);
        }

        @Override
        public Object getResult() throws IllegalStateException {
            Object result;
            if (!this.isDone()) {
                throw new IllegalStateException("Job is not done yet. ");
            }
            try {
                result = super.get();
            }
            catch (InterruptedException e) {
                throw new InternalException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof InvocationTargetException && (cause = ((InvocationTargetException)cause).getTargetException()) instanceof WebApplicationException) {
                    throw (WebApplicationException)cause;
                }
                throw new InternalException(cause);
            }
            return result;
        }

        @Override
        public Map<String, Object> getContext() {
            return this.context;
        }
    }

    public static class ManyJobsPolicy
    implements RejectedExecutionHandler {
        private final RejectedExecutionHandler delegate;

        public ManyJobsPolicy(RejectedExecutionHandler delegate) {
            this.delegate = delegate;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.getPoolSize() >= executor.getCorePoolSize()) {
                throw new RejectedExecutionException("Can't accept new asynchronous request. Too many asynchronous jobs in progress. ");
            }
            this.delegate.rejectedExecution(r, executor);
        }
    }
}

