/*
 * Copyright (C) 2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.everrest.core.impl;

import org.everrest.core.util.CaselessUnmodifiableMultivaluedMap;

import java.util.List;
import java.util.Map;

import javax.ws.rs.core.MultivaluedMap;

/**
 * Read only case insensitive {@link MultivaluedMap}.
 *
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id: InputHeadersMap.java 71 2010-10-25 15:19:37Z andrew00x $
 */
public final class InputHeadersMap extends CaselessUnmodifiableMultivaluedMap<String>
{

   private static final long serialVersionUID = -96963220577144285L;

   public InputHeadersMap()
   {
      super();
   }

   public InputHeadersMap(Map<String, List<String>> m)
   {
      super(m);
   }

}
