/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.method.filter;

import java.lang.annotation.Annotation;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.Filter;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.method.MethodInvokerFilter;
import org.everrest.core.resource.GenericMethodResource;

@Filter
public class SecurityConstraint
implements MethodInvokerFilter {
    @Override
    public void accept(GenericMethodResource method) throws WebApplicationException {
        SecurityContext security = ApplicationContextImpl.getCurrent().getSecurityContext();
        for (Annotation a : method.getAnnotations()) {
            Class<? extends Annotation> aClass = a.annotationType();
            if (aClass == PermitAll.class) {
                return;
            }
            if (aClass == DenyAll.class) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User not authorized to call this method.").type("text/plain").build());
            }
            if (aClass != RolesAllowed.class) continue;
            for (String role : ((RolesAllowed)a).value()) {
                if (!security.isUserInRole(role)) continue;
                return;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"User not authorized to call this method.").type("text/plain").build());
        }
    }
}

