/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.uri;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.impl.uri.PathSegmentImpl;
import org.everrest.core.util.NoSyncByteArrayOutputStream;

public final class UriComponent {
    public static final int SCHEME = 0;
    public static final int USER_INFO = 1;
    public static final int HOST = 2;
    public static final int PORT = 3;
    public static final int PATH_SEGMENT = 4;
    public static final int PATH = 5;
    public static final int QUERY = 6;
    public static final int FRAGMENT = 7;
    public static final int SSP = 8;
    public static final String PERCENT = "%25";
    private static final String ALPHA = UriComponent.fillTable("A-Z") + UriComponent.fillTable("a-z");
    private static final String DIGIT = UriComponent.fillTable("0-9");
    private static final String UNRESERVED = ALPHA + DIGIT + "-._~";
    private static final String GEN_DELIM = ":/?#[]@";
    private static final String SUB_DELIM = "!$&'()*+,;=";
    private static final String HEX_DIGITS = "0123456789ABCDEF";
    private static final String[] ENCODING = new String[9];
    private static final String[][] ENCODED = new String[9][128];
    private static final Charset UTF8;

    private static String fillTable(String statement) {
        StringBuilder sb = new StringBuilder();
        if (statement.length() != 3 || statement.charAt(1) != '-') {
            throw new IllegalArgumentException("Illegal format of source string, e. g. A-Z");
        }
        char end = statement.charAt(2);
        for (char c = statement.charAt(0); c <= end; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static URI normalize(URI uri) {
        String oldPath = uri.getRawPath();
        String normalizedPath = UriComponent.normalize(oldPath);
        if (normalizedPath.equals(oldPath)) {
            return uri;
        }
        return UriBuilder.fromUri((URI)uri).replacePath(normalizedPath).build(new Object[0]);
    }

    private static String normalize(String path) {
        String inputBuffer = path;
        StringBuilder outputBuffer = new StringBuilder();
        if (inputBuffer.contains("//")) {
            inputBuffer = inputBuffer.replaceAll("//", "/");
        }
        while (inputBuffer.length() != 0) {
            if (inputBuffer.startsWith("../") || inputBuffer.startsWith("./")) {
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf(47) + 1, inputBuffer.length());
                continue;
            }
            if (inputBuffer.startsWith("/./") || inputBuffer.startsWith("/.") && UriComponent.isCompletePathSeg(".", inputBuffer)) {
                if (inputBuffer.equals("/.")) {
                    inputBuffer = "";
                    outputBuffer.append('/');
                    continue;
                }
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf(47, 1), inputBuffer.length());
                continue;
            }
            if (inputBuffer.startsWith("/../") || inputBuffer.startsWith("/..") && UriComponent.isCompletePathSeg("..", inputBuffer)) {
                if (inputBuffer.equals("/..")) {
                    inputBuffer = "";
                    outputBuffer.delete(outputBuffer.lastIndexOf("/") + 1, outputBuffer.length());
                    continue;
                }
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf(47, 1), inputBuffer.length());
                outputBuffer.delete(outputBuffer.lastIndexOf("/"), outputBuffer.length());
                continue;
            }
            if (inputBuffer.equals(".") || inputBuffer.equals("..")) {
                inputBuffer = "";
                continue;
            }
            if (inputBuffer.indexOf(47) != inputBuffer.lastIndexOf(47)) {
                outputBuffer.append(inputBuffer.substring(0, inputBuffer.indexOf(47, 1)));
                inputBuffer = inputBuffer.substring(inputBuffer.indexOf(47, 1));
                continue;
            }
            outputBuffer.append(inputBuffer);
            inputBuffer = "";
        }
        return outputBuffer.toString();
    }

    private static boolean isCompletePathSeg(String segment, String path) {
        return path.equals("/" + segment) || path.charAt(path.indexOf(segment) + segment.length()) == '/';
    }

    public static String encode(String str, int component, boolean containsUriParams) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        return UriComponent.encodingInt(str, component, containsUriParams, false);
    }

    public static String validate(String str, int component, boolean containsUriParams) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < '\u0080' && !UriComponent.needEncode(ch, component) || containsUriParams && (ch == '{' || ch == '}') || ch == '%') continue;
            throw new IllegalArgumentException("Illegal character, index " + i + ": " + str);
        }
        return str;
    }

    public static String recognizeEncode(String str, int component, boolean containsUriParams) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        return UriComponent.encodingInt(str, component, containsUriParams, true);
    }

    private static String encodingInt(String str, int component, boolean containsUriParams, boolean recognizeEncoded) {
        int length = str.length();
        boolean encode = false;
        for (int i = 0; i < length && !encode; ++i) {
            encode = UriComponent.needEncode(str.charAt(i), component);
        }
        if (encode) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                char ch = str.charAt(i);
                if (ch == '%' && recognizeEncoded) {
                    if (UriComponent.checkHexCharacters(str, i)) {
                        sb.append(ch);
                        sb.append(str.charAt(++i));
                        sb.append(str.charAt(++i));
                        continue;
                    }
                    sb.append(PERCENT);
                    continue;
                }
                if (containsUriParams && (ch == '{' || ch == '}')) {
                    sb.append(ch);
                    continue;
                }
                if (ch < '\u0080') {
                    sb.append(UriComponent.needEncode(ch, component) ? ENCODED[component][ch] : Character.valueOf(ch));
                    continue;
                }
                UriComponent.addUTF8Encoded(ch, sb);
            }
            return sb.toString();
        }
        return str;
    }

    public static String decode(String str, int component) {
        if (str == null) {
            throw new IllegalArgumentException("Decoded string is null");
        }
        int length = str.length();
        if (length < 3 && str.indexOf(37) > 0) {
            throw new IllegalArgumentException("Malformed string " + str);
        }
        int p = str.lastIndexOf(37);
        if (p > 0 && p > length - 3) {
            throw new IllegalArgumentException("Malformed string at index " + p);
        }
        p = 0;
        StringBuilder sb = new StringBuilder();
        NoSyncByteArrayOutputStream out = new NoSyncByteArrayOutputStream(4);
        while (p < length) {
            char c = str.charAt(p);
            if (c == '%') {
                p = UriComponent.percentDecode(str, p, out);
                byte[] buff = ((ByteArrayOutputStream)out).toByteArray();
                if (buff.length == 1 && (buff[0] & 0xFF) < 128) {
                    sb.append((char)buff[0]);
                } else {
                    UriComponent.addUTF8Decoded(buff, sb);
                }
                ((ByteArrayOutputStream)out).reset();
                continue;
            }
            sb.append(c == '+' ? (char)' ' : (char)c);
            ++p;
        }
        return sb.toString();
    }

    private static boolean needEncode(char ch, int component) {
        return ENCODING[component].indexOf(ch) == -1;
    }

    private static void addPercentEncoded(int c, StringBuilder sb) {
        sb.append('%');
        sb.append(HEX_DIGITS.charAt(c >> 4));
        sb.append(HEX_DIGITS.charAt(c & 0xF));
    }

    private static void addUTF8Encoded(char c, StringBuilder sb) {
        ByteBuffer buf = UTF8.encode("" + c);
        while (buf.hasRemaining()) {
            UriComponent.addPercentEncoded(buf.get() & 0xFF, sb);
        }
    }

    private static int percentDecode(String str, int p, ByteArrayOutputStream out) {
        int length = str.length();
        do {
            char hc = UriComponent.getHexCharacter(str, ++p);
            char lc = UriComponent.getHexCharacter(str, ++p);
            int r = (Character.isDigit(hc) ? hc - 48 : hc - 65 + 10) << 4 | (Character.isDigit(lc) ? lc - 48 : lc - 65 + 10);
            out.write((byte)r);
        } while (++p != length && str.charAt(p) == '%');
        return p;
    }

    public static boolean checkHexCharacters(String s, int p) {
        if (p > s.length() - 3) {
            return false;
        }
        try {
            UriComponent.getHexCharacter(s, ++p);
            UriComponent.getHexCharacter(s, ++p);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static char getHexCharacter(String s, int p) {
        char c = s.charAt(p);
        if (c >= '0' && c <= '9') {
            return c;
        }
        if (c >= 'A' && c <= 'F') {
            return c;
        }
        if (c >= 'a' && c <= 'f') {
            return Character.toUpperCase(c);
        }
        throw new IllegalArgumentException("Malformed string at index " + p);
    }

    private static void addUTF8Decoded(byte[] buff, StringBuilder sb) {
        CharBuffer cbuff = UTF8.decode(ByteBuffer.wrap(buff));
        sb.append(cbuff.toString());
    }

    public static List<PathSegment> parsePathSegments(String path, boolean decode) {
        ArrayList<PathSegment> result = new ArrayList<PathSegment>();
        if (path != null && !path.isEmpty()) {
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            int p = 0;
            int n = 0;
            while (n < path.length()) {
                n = path.indexOf(47, p);
                if (n < 0) {
                    n = path.length();
                }
                result.add(PathSegmentImpl.fromString(path.substring(p, n), decode));
                p = n + 1;
            }
        }
        return result;
    }

    public static MultivaluedMap<String, String> parseQueryString(String rawQuery, boolean decode) {
        MultivaluedMapImpl result = new MultivaluedMapImpl();
        if (rawQuery != null && !rawQuery.isEmpty()) {
            int p = 0;
            int n = 0;
            while (n < rawQuery.length()) {
                String value;
                String name;
                String pair;
                n = rawQuery.indexOf(38, p);
                if (n < 0) {
                    n = rawQuery.length();
                }
                if ((pair = rawQuery.substring(p, n)).isEmpty()) continue;
                int eq = pair.indexOf(61);
                if (eq < 0) {
                    name = pair;
                    value = "";
                } else {
                    name = pair.substring(0, eq);
                    value = pair.substring(eq + 1);
                }
                result.add(decode ? UriComponent.decode(name, 6) : name, decode ? UriComponent.decode(value, 6) : value);
                p = n + 1;
            }
        }
        return result;
    }

    private UriComponent() {
    }

    static {
        UriComponent.ENCODING[0] = ALPHA + DIGIT + "+-.";
        UriComponent.ENCODING[1] = UNRESERVED + SUB_DELIM + ':';
        UriComponent.ENCODING[2] = UNRESERVED + SUB_DELIM;
        UriComponent.ENCODING[3] = DIGIT;
        UriComponent.ENCODING[4] = UNRESERVED + SUB_DELIM + ":@";
        UriComponent.ENCODING[5] = ENCODING[4] + '/';
        UriComponent.ENCODING[6] = UNRESERVED + "!$'()*,;:@?";
        UriComponent.ENCODING[7] = ENCODING[6];
        UriComponent.ENCODING[8] = UNRESERVED + SUB_DELIM + GEN_DELIM;
        for (int i = 0; i <= 8; ++i) {
            for (int j = 0; j < 128; ++j) {
                if (ENCODING[i].indexOf(j) >= 0) continue;
                StringBuilder sb = new StringBuilder();
                UriComponent.addPercentEncoded(j, sb);
                UriComponent.ENCODED[i][j] = sb.toString();
            }
        }
        UTF8 = Charset.forName("UTF-8");
    }
}

