/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import org.everrest.core.impl.AnnotatedLifecycleMethodStrategy;

public final class LifecycleComponent {
    private static final LifecycleMethodStrategy defaultStrategy = new AnnotatedLifecycleMethodStrategy();
    private final Object component;
    private final LifecycleMethodStrategy lifecycleStrategy;
    private State state;

    public LifecycleComponent(Object component) {
        this(component, defaultStrategy);
    }

    public LifecycleComponent(Object component, LifecycleMethodStrategy lifecycleStrategy) {
        this.component = component;
        this.lifecycleStrategy = lifecycleStrategy;
    }

    public Object getComponent() {
        return this.component;
    }

    public void initialize() {
        this.lifecycleStrategy.invokeInitializeMethods(this.getComponent());
        this.state = State.INITIALIZED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.lifecycleStrategy.invokeDestroyMethods(this.getComponent());
        }
        finally {
            this.state = State.DESTROYED;
        }
    }

    public boolean isInitialized() {
        return this.state == State.INITIALIZED;
    }

    public boolean isDestroyed() {
        return this.state == State.DESTROYED;
    }

    public static interface LifecycleMethodStrategy {
        public void invokeInitializeMethods(Object var1);

        public void invokeDestroyMethods(Object var1);
    }

    private static enum State {
        INITIALIZED,
        DESTROYED;

    }
}

