/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import javax.ws.rs.Path;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.everrest.core.Filter;
import org.everrest.core.RequestFilter;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.method.MethodInvokerFilter;

public final class RestComponentResolver {
    private ResourceBinder resources;
    private ProviderBinder providers;

    public RestComponentResolver(ResourceBinder resources, ProviderBinder providers) {
        this.resources = resources;
        this.providers = providers;
    }

    public void addSingleton(Object instance) {
        Class<?> clazz = instance.getClass();
        if (clazz.getAnnotation(Provider.class) != null) {
            if (instance instanceof ContextResolver) {
                this.providers.addContextResolver((ContextResolver)instance);
            }
            if (instance instanceof ExceptionMapper) {
                this.providers.addExceptionMapper((ExceptionMapper)instance);
            }
            if (instance instanceof MessageBodyReader) {
                this.providers.addMessageBodyReader((MessageBodyReader)instance);
            }
            if (instance instanceof MessageBodyWriter) {
                this.providers.addMessageBodyWriter((MessageBodyWriter)instance);
            }
        } else if (clazz.getAnnotation(Filter.class) != null) {
            if (instance instanceof MethodInvokerFilter) {
                this.providers.addMethodInvokerFilter((MethodInvokerFilter)instance);
            }
            if (instance instanceof RequestFilter) {
                this.providers.addRequestFilter((RequestFilter)instance);
            }
            if (instance instanceof ResponseFilter) {
                this.providers.addResponseFilter((ResponseFilter)instance);
            }
        } else if (clazz.getAnnotation(Path.class) != null) {
            this.resources.addResource(instance, null);
        }
    }

    public void addPerRequest(Class clazz) {
        if (clazz.getAnnotation(Provider.class) != null) {
            if (ContextResolver.class.isAssignableFrom(clazz)) {
                this.providers.addContextResolver(clazz);
            }
            if (ExceptionMapper.class.isAssignableFrom(clazz)) {
                this.providers.addExceptionMapper(clazz);
            }
            if (MessageBodyReader.class.isAssignableFrom(clazz)) {
                this.providers.addMessageBodyReader(clazz);
            }
            if (MessageBodyWriter.class.isAssignableFrom(clazz)) {
                this.providers.addMessageBodyWriter(clazz);
            }
        } else if (clazz.getAnnotation(Filter.class) != null) {
            if (MethodInvokerFilter.class.isAssignableFrom(clazz)) {
                this.providers.addMethodInvokerFilter(clazz);
            }
            if (RequestFilter.class.isAssignableFrom(clazz)) {
                this.providers.addRequestFilter(clazz);
            }
            if (ResponseFilter.class.isAssignableFrom(clazz)) {
                this.providers.addResponseFilter(clazz);
            }
        } else if (clazz.getAnnotation(Path.class) != null) {
            this.resources.addResource(clazz, null);
        }
    }
}

