/*
 * Copyright (C) 2012 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.everrest.core.tools;

import java.security.Principal;

/**
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id: $
 */
public class SimplePrincipal implements Principal
{
   private final String identity;

   public SimplePrincipal(String identity)
   {
      this.identity = identity;
   }

   @Override
   public String getName()
   {
      return identity;
   }

   @Override
   public boolean equals(Object obj)
   {
      if (this == obj)
      {
         return true;
      }
      if (obj == null || getClass() != obj.getClass())
      {
         return false;
      }

      SimplePrincipal other = (SimplePrincipal)obj;
      return identity == null ? other.identity == null : identity.equals(other.identity);
   }

   @Override
   public int hashCode()
   {
      int hash = 7;
      hash = hash * 31 + (identity == null ? 0 : identity.hashCode());
      return hash;
   }

   @Override
   public String toString()
   {
      return "SimplePrincipal{identity='" + identity + '\'' + '}';
   }
}
