/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.everrest.core.ComponentLifecycleScope;
import org.everrest.core.ObjectFactory;
import org.everrest.core.PerRequestObjectFactory;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResourcePublicationException;
import org.everrest.core.SingletonObjectFactory;
import org.everrest.core.impl.ResourceListener;
import org.everrest.core.impl.RuntimeDelegateImpl;
import org.everrest.core.impl.resource.AbstractResourceDescriptorImpl;
import org.everrest.core.impl.resource.ResourceDescriptorValidator;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.uri.UriPattern;
import org.everrest.core.util.Logger;

public class ResourceBinderImpl
implements ResourceBinder {
    public static final String RESOURCE_EXPIRED = "org.everrest.resource.expiration.date";
    private static final Logger LOG = Logger.getLogger(ResourceBinderImpl.class);
    protected static final Comparator<ObjectFactory<AbstractResourceDescriptor>> RESOURCE_COMPARATOR = new Comparator<ObjectFactory<AbstractResourceDescriptor>>(){

        @Override
        public int compare(ObjectFactory<AbstractResourceDescriptor> o1, ObjectFactory<AbstractResourceDescriptor> o2) {
            return UriPattern.URIPATTERN_COMPARATOR.compare(o1.getObjectModel().getUriPattern(), o2.getObjectModel().getUriPattern());
        }
    };
    protected boolean cleanerStop = false;
    protected final List<ObjectFactory<AbstractResourceDescriptor>> rootResources = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>();
    protected final ResourceDescriptorVisitor rdv = ResourceDescriptorValidator.getInstance();
    protected final List<ResourceListener> resourceListeners = new ArrayList<ResourceListener>();

    public ResourceBinderImpl() {
        RuntimeDelegateImpl rd = new RuntimeDelegateImpl();
        RuntimeDelegate.setInstance((RuntimeDelegate)rd);
    }

    @Override
    public void addResource(Class<?> resourceClass, MultivaluedMap<String, String> properties) {
        Path path = resourceClass.getAnnotation(Path.class);
        if (path == null) {
            throw new ResourcePublicationException("Resource class " + resourceClass.getName() + " it is not root resource. " + "Path annotation javax.ws.rs.Path is not specified for this class.");
        }
        try {
            AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(resourceClass, ComponentLifecycleScope.PER_REQUEST);
            descriptor.accept(this.rdv);
            if (properties != null) {
                descriptor.getProperties().putAll(properties);
            }
            this.addResource(new PerRequestObjectFactory<AbstractResourceDescriptor>(descriptor));
        }
        catch (Exception e) {
            if (e instanceof ResourcePublicationException) {
                throw (ResourcePublicationException)e;
            }
            throw new ResourcePublicationException(e.getMessage(), e);
        }
    }

    @Override
    public void addResource(Object resource, MultivaluedMap<String, String> properties) {
        Path path = resource.getClass().getAnnotation(Path.class);
        if (path == null) {
            throw new ResourcePublicationException("Resource class " + resource.getClass().getName() + " it is not root resource. " + "Path annotation javax.ws.rs.Path is not specified for this class.");
        }
        try {
            AbstractResourceDescriptorImpl descriptor = new AbstractResourceDescriptorImpl(resource.getClass(), ComponentLifecycleScope.SINGLETON);
            descriptor.accept(this.rdv);
            if (properties != null) {
                descriptor.getProperties().putAll(properties);
            }
            this.addResource(new SingletonObjectFactory<AbstractResourceDescriptor>(descriptor, resource));
        }
        catch (Exception e) {
            if (e instanceof ResourcePublicationException) {
                throw (ResourcePublicationException)e;
            }
            throw new ResourcePublicationException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(ObjectFactory<AbstractResourceDescriptor> resourceFactory) {
        UriPattern pattern = resourceFactory.getObjectModel().getUriPattern();
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            for (ObjectFactory<AbstractResourceDescriptor> resource : this.rootResources) {
                if (!resource.getObjectModel().getUriPattern().equals(resourceFactory.getObjectModel().getUriPattern())) continue;
                if (resource.getObjectModel().getObjectClass() == resourceFactory.getObjectModel().getObjectClass()) {
                    LOG.warn("Resource " + resourceFactory.getObjectModel().getObjectClass().getName() + " already registered.");
                    continue;
                }
                throw new ResourcePublicationException("Resource class " + resourceFactory.getObjectModel().getObjectClass().getName() + " can't be registered. Resource class " + resource.getObjectModel().getObjectClass().getName() + " with the same pattern " + pattern + " already registered.");
            }
            this.rootResources.add(resourceFactory);
            Collections.sort(this.rootResources, RESOURCE_COMPARATOR);
            for (ResourceListener listener : this.resourceListeners) {
                listener.resourceAdded(resourceFactory.getObjectModel());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Add resource: " + resourceFactory.getObjectModel());
            }
        }
    }

    public void addResourceListener(ResourceListener listener) {
        this.resourceListeners.add(listener);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource listener added: " + listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            this.rootResources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectFactory<AbstractResourceDescriptor> getMatchedResource(String requestPath, List<String> parameterValues) {
        ObjectFactory<AbstractResourceDescriptor> resourceFactory = null;
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            for (ObjectFactory<AbstractResourceDescriptor> resource : this.rootResources) {
                int len;
                if (!resource.getObjectModel().getUriPattern().match(requestPath, parameterValues) || parameterValues.get((len = parameterValues.size()) - 1) != null && !parameterValues.get(len - 1).equals("/") && 0 == resource.getObjectModel().getSubResourceMethods().size() + resource.getObjectModel().getSubResourceLocators().size()) continue;
                resourceFactory = resource;
                break;
            }
        }
        return resourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectFactory<AbstractResourceDescriptor>> getResources() {
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            ArrayList<ObjectFactory<AbstractResourceDescriptor>> copy = new ArrayList<ObjectFactory<AbstractResourceDescriptor>>(this.rootResources.size());
            copy.addAll(this.rootResources);
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            return this.rootResources.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectFactory<AbstractResourceDescriptor> removeResource(Class<?> clazz) {
        ObjectFactory<AbstractResourceDescriptor> resource = null;
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            Iterator<ObjectFactory<AbstractResourceDescriptor>> iter = this.rootResources.iterator();
            while (iter.hasNext() && resource == null) {
                ObjectFactory<AbstractResourceDescriptor> next = iter.next();
                Class<?> resourceClass = next.getObjectModel().getObjectClass();
                if (!clazz.equals(resourceClass)) continue;
                resource = next;
                iter.remove();
            }
            if (resource != null) {
                for (ResourceListener listener : this.resourceListeners) {
                    listener.resourceRemoved((AbstractResourceDescriptor)resource.getObjectModel());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove resource: " + resource.getObjectModel());
                }
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectFactory<AbstractResourceDescriptor> removeResource(String path) {
        ObjectFactory<AbstractResourceDescriptor> resource = null;
        UriPattern pattern = new UriPattern(path);
        List<ObjectFactory<AbstractResourceDescriptor>> list = this.rootResources;
        synchronized (list) {
            Iterator<ObjectFactory<AbstractResourceDescriptor>> iter = this.rootResources.iterator();
            while (iter.hasNext() && resource == null) {
                ObjectFactory<AbstractResourceDescriptor> next = iter.next();
                UriPattern resourcePattern = next.getObjectModel().getUriPattern();
                if (!pattern.equals(resourcePattern)) continue;
                resource = next;
                iter.remove();
            }
            if (resource != null) {
                for (ResourceListener listener : this.resourceListeners) {
                    listener.resourceRemoved((AbstractResourceDescriptor)resource.getObjectModel());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Remove resource: " + resource.getObjectModel());
                }
            }
        }
        return resource;
    }

    protected class ResourceCleaner
    implements Runnable {
        private final long cleanerDelay;

        public ResourceCleaner(int cleanerDelay) {
            this.cleanerDelay = cleanerDelay * 1000;
        }

        @Override
        public void run() {
            while (!ResourceBinderImpl.this.cleanerStop) {
                try {
                    Thread.sleep(this.cleanerDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ResourceBinderImpl.this.cleanerStop) continue;
                this.processResources();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processResources() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Start resource cleaner");
            }
            List<ObjectFactory<AbstractResourceDescriptor>> list = ResourceBinderImpl.this.rootResources;
            synchronized (list) {
                Iterator<ObjectFactory<AbstractResourceDescriptor>> iter = ResourceBinderImpl.this.rootResources.iterator();
                while (iter.hasNext()) {
                    ObjectFactory<AbstractResourceDescriptor> next = iter.next();
                    List<String> str = next.getObjectModel().getProperty(ResourceBinderImpl.RESOURCE_EXPIRED);
                    long expirationDate = -1L;
                    if (str != null && str.size() > 0) {
                        try {
                            expirationDate = Long.parseLong(str.get(0));
                        }
                        catch (NumberFormatException ignored) {
                            // empty catch block
                        }
                    }
                    if (expirationDate <= 0L || expirationDate >= System.currentTimeMillis()) continue;
                    iter.remove();
                    for (ResourceListener listener : ResourceBinderImpl.this.resourceListeners) {
                        listener.resourceRemoved(next.getObjectModel());
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Remove expired resource: " + next.getObjectModel());
                }
            }
        }
    }
}

