/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.everrest.core.DependencySupplier;
import org.everrest.core.FilterDescriptor;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.ObjectFactory;
import org.everrest.core.RequestFilter;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResponseFilter;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.impl.method.filter.SecurityConstraint;
import org.everrest.core.impl.uri.UriComponent;
import org.everrest.core.util.Logger;

public class RequestHandlerImpl
implements RequestHandler {
    private static final Logger LOG = Logger.getLogger(RequestHandlerImpl.class);
    private static final Map<String, String> properties = new HashMap<String, String>();
    private final RequestDispatcher dispatcher;
    private final DependencySupplier dependencySupplier;
    private final EverrestConfiguration config;
    private final ProviderBinder providers;

    public static String getProperty(String name) {
        return properties.get(name);
    }

    public static void setProperty(String name, String value) {
        if (value == null) {
            properties.remove(name);
        } else {
            properties.put(name, value);
        }
    }

    public RequestHandlerImpl(RequestDispatcher dispatcher, ProviderBinder providers, DependencySupplier dependencySupplier, EverrestConfiguration config) {
        this.dispatcher = dispatcher;
        this.dependencySupplier = dependencySupplier;
        this.providers = providers == null ? ProviderBinder.getInstance() : providers;
        EverrestConfiguration everrestConfiguration = this.config = config == null ? new EverrestConfiguration() : config;
        if (this.config.isCheckSecurity()) {
            this.providers.addMethodInvokerFilter(new SecurityConstraint());
        }
    }

    public RequestHandlerImpl(RequestDispatcher dispatcher, DependencySupplier dependencySupplier, EverrestConfiguration config) {
        this(dispatcher, null, dependencySupplier, config);
    }

    public RequestHandlerImpl(ResourceBinder resources, DependencySupplier dependencySupplier) {
        this(new RequestDispatcher(resources), null, dependencySupplier, new EverrestConfiguration());
    }

    public RequestHandlerImpl(ResourceBinder resources, ProviderBinder providers, DependencySupplier dependencySupplier, EverrestConfiguration config) {
        this(new RequestDispatcher(resources), providers, dependencySupplier, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(GenericContainerRequest request, GenericContainerResponse response) throws UnhandledException, IOException {
        try {
            String method;
            if (this.config.isNormalizeUri()) {
                request.setUris(UriComponent.normalize(request.getRequestUri()), request.getBaseUri());
            }
            if (this.config.isHttpMethodOverride() && (method = (String)request.getRequestHeaders().getFirst((Object)"X-HTTP-Method-Override")) != null) {
                request.setMethod(method);
            }
            ApplicationContextImpl context = new ApplicationContextImpl(request, response, this.providers);
            context.getProperties().putAll(properties);
            context.setDependencySupplier(this.dependencySupplier);
            ApplicationContextImpl.setCurrent(context);
            for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getRequestFilters(context.getPath())) {
                ((RequestFilter)factory.getInstance(context)).doFilter(request);
            }
            try {
                String jaxrsHeader;
                this.dispatcher.dispatch(request, response);
                if (response.getHttpHeaders().getFirst((Object)"JAXRS-Body-Provided") == null && (jaxrsHeader = this.getJaxrsHeader(response.getStatus())) != null) {
                    response.getHttpHeaders().putSingle((Object)"JAXRS-Body-Provided", (Object)jaxrsHeader);
                }
            }
            catch (Exception e) {
                if (e instanceof WebApplicationException) {
                    String jaxrsHeader;
                    Response errorResponse = ((WebApplicationException)e).getResponse();
                    ExceptionMapper<WebApplicationException> excmap = context.getProviders().getExceptionMapper(WebApplicationException.class);
                    int errorStatus = errorResponse.getStatus();
                    if (errorStatus < 500) {
                        if (LOG.isDebugEnabled() && e.getCause() != null) {
                            LOG.warn("WebApplication exception occurs.", e.getCause());
                        }
                    } else if (e.getCause() != null) {
                        LOG.warn("WebApplication exception occurs.", e.getCause());
                    }
                    if (errorResponse.getEntity() == null) {
                        if (excmap != null) {
                            errorResponse = excmap.toResponse((Throwable)e);
                        } else if (e.getMessage() != null) {
                            errorResponse = this.createErrorResponse(errorStatus, e.getMessage());
                        }
                    } else if (errorResponse.getMetadata().getFirst((Object)"JAXRS-Body-Provided") == null && (jaxrsHeader = this.getJaxrsHeader(errorStatus)) != null) {
                        errorResponse.getMetadata().putSingle((Object)"JAXRS-Body-Provided", (Object)jaxrsHeader);
                    }
                    response.setResponse(errorResponse);
                }
                if (e instanceof InternalException) {
                    Throwable cause = e.getCause();
                    Class<?> causeClazz = cause.getClass();
                    ExceptionMapper<?> excmap = context.getProviders().getExceptionMapper(causeClazz);
                    while (causeClazz != null && excmap == null) {
                        excmap = context.getProviders().getExceptionMapper(causeClazz);
                        if (excmap != null) continue;
                        causeClazz = causeClazz.getSuperclass();
                    }
                    if (excmap != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Internal error occurs.", cause);
                        }
                        response.setResponse(excmap.toResponse(e.getCause()));
                    }
                    LOG.error("Internal error occurs.", cause);
                    throw new UnhandledException(e.getCause());
                }
                throw new UnhandledException(e);
            }
            for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getResponseFilters(context.getPath())) {
                ((ResponseFilter)factory.getInstance(context)).doFilter(response);
            }
            response.writeResponse();
        }
        finally {
            ApplicationContextImpl.setCurrent(null);
        }
    }

    private Response createErrorResponse(int status, String message) {
        Response.ResponseBuilder responseBuilder = Response.status((int)status);
        responseBuilder.entity((Object)message).type("text/plain");
        String jaxrsHeader = this.getJaxrsHeader(status);
        if (jaxrsHeader != null) {
            responseBuilder.header("JAXRS-Body-Provided", (Object)jaxrsHeader);
        }
        return responseBuilder.build();
    }

    private String getJaxrsHeader(int status) {
        if (status >= 400) {
            return "Error-Message";
        }
        return null;
    }
}

