/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.everrest.core.impl.resource.PathValue;
import org.everrest.core.method.MethodParameter;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.resource.SubResourceLocatorDescriptor;
import org.everrest.core.uri.UriPattern;

public class SubResourceLocatorDescriptorImpl
implements SubResourceLocatorDescriptor {
    private final PathValue path;
    private final UriPattern uriPattern;
    private final Method method;
    private final AbstractResourceDescriptor parentResource;
    private final List<MethodParameter> parameters;
    private final Annotation[] additional;

    SubResourceLocatorDescriptorImpl(PathValue path, Method method, List<MethodParameter> parameters, AbstractResourceDescriptor parentResource, Annotation[] additional) {
        this.path = path;
        this.uriPattern = new UriPattern(path.getPath());
        this.method = method;
        this.parameters = parameters;
        this.parentResource = parentResource;
        this.additional = additional;
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitSubResourceLocatorDescriptor(this);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public List<MethodParameter> getMethodParameters() {
        return this.parameters;
    }

    @Override
    public AbstractResourceDescriptor getParentResource() {
        return this.parentResource;
    }

    @Override
    public Class<?> getResponseType() {
        return this.getMethod().getReturnType();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.additional;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ SubResourceMethodDescriptorImpl: ");
        sb.append("resource: " + this.getParentResource() + "; ").append("path: " + this.getPathValue() + "; ").append("return type: " + this.getResponseType()).append(" ]");
        return sb.toString();
    }
}

