/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ContainerResponse;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestProcessor;
import org.everrest.core.servlet.ServletContainerRequest;
import org.everrest.core.servlet.ServletContainerResponseWriter;
import org.everrest.core.util.Logger;

public class EverrestServlet
extends HttpServlet {
    private static final long serialVersionUID = -8234561611241680339L;
    private static final Logger LOG = Logger.getLogger(EverrestServlet.class.getName());
    protected EverrestProcessor processor;
    protected ServletConfig servletConfig;

    public void init(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        this.processor = (EverrestProcessor)servletConfig.getServletContext().getAttribute(EverrestProcessor.class.getName());
    }

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        EnvironmentContext env = new EnvironmentContext();
        env.put(HttpServletRequest.class, httpRequest);
        env.put(HttpServletResponse.class, httpResponse);
        env.put(ServletConfig.class, this.servletConfig);
        env.put(ServletContext.class, this.servletConfig.getServletContext());
        try {
            ServletContainerRequest request = new ServletContainerRequest(httpRequest);
            ContainerResponse response = new ContainerResponse(new ServletContainerResponseWriter(httpResponse));
            this.processor.process(request, response, env);
        }
        catch (IOException ioe) {
            if (ioe.getClass().getName().equals("org.apache.catalina.connector.ClientAbortException")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(ioe.getMessage(), ioe);
                }
            }
            throw ioe;
        }
        catch (UnhandledException e) {
            LOG.error(e.getMessage(), e);
            throw new ServletException((Throwable)e);
        }
    }
}

