/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.uri;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.everrest.core.impl.uri.UriComponent;
import org.everrest.core.uri.UriTemplateParser;

public class UriPattern {
    public static final Comparator<UriPattern> URIPATTERN_COMPARATOR = new UriPatternComparator();
    private static final String URI_PATTERN_TAIL = "(/.*)?";
    private final List<String> parameterNames;
    private final String template;
    private final int numberOfCharacters;
    private final Pattern pattern;
    private final String regex;
    private final int[] groupIndexes;

    public UriPattern(String template) {
        if (template.length() > 0 && template.charAt(0) != '/') {
            template = "/" + template;
        }
        UriTemplateParser parser = new UriTemplateParser(template);
        this.template = parser.getTemplate();
        this.parameterNames = Collections.unmodifiableList(parser.getParameterNames());
        this.numberOfCharacters = parser.getNumberOfLiteralCharacters();
        int[] indxs = parser.getGroupIndexes();
        if (indxs != null) {
            this.groupIndexes = new int[indxs.length + 1];
            System.arraycopy(indxs, 0, this.groupIndexes, 0, indxs.length);
            this.groupIndexes[this.groupIndexes.length - 1] = indxs[indxs.length - 1] + 1;
        } else {
            this.groupIndexes = null;
        }
        String regex = parser.getRegex();
        if (regex.endsWith("/")) {
            regex = regex.substring(0, regex.length() - 1);
        }
        this.regex = regex + URI_PATTERN_TAIL;
        this.pattern = Pattern.compile(this.regex);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.getRegex().equals(((UriPattern)obj).getRegex());
    }

    public int hashCode() {
        return this.template.hashCode() + this.regex.hashCode();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getRegex() {
        return this.regex;
    }

    public int getNumberOfLiteralCharacters() {
        return this.numberOfCharacters;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public boolean match(String uri, List<String> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("list is null");
        }
        if (uri == null || uri.length() == 0) {
            return this.pattern == null;
        }
        if (this.pattern == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(uri);
        if (!m.matches()) {
            return false;
        }
        parameters.clear();
        if (this.groupIndexes == null) {
            for (int i = 1; i <= m.groupCount(); ++i) {
                parameters.add(m.group(i));
            }
        } else {
            for (int i = 0; i < this.groupIndexes.length - 1; ++i) {
                parameters.add(m.group(this.groupIndexes[i]));
            }
        }
        return true;
    }

    public String toString() {
        return this.regex;
    }

    public static String createUriWithValues(String schema, String userInfo, String host, int port, String path, String query, String fragment, Map<String, ? extends Object> values, boolean encode) {
        StringBuilder sb = new StringBuilder();
        if (schema != null) {
            UriPattern.appendUriPart(sb, schema, 0, values, false);
            sb.append(':');
        }
        if (userInfo != null || host != null || port != -1) {
            sb.append('/').append('/');
            if (userInfo != null && userInfo.length() > 0) {
                UriPattern.appendUriPart(sb, userInfo, 1, values, encode);
                sb.append('@');
            }
            if (host != null) {
                UriPattern.appendUriPart(sb, host, 2, values, encode);
            }
            if (port != -1) {
                sb.append(':');
                UriPattern.appendUriPart(sb, "" + port, 3, values, encode);
            }
        }
        if (path != null) {
            if (sb.length() > 0 && path.length() > 0 && path.charAt(0) != '/') {
                sb.append('/');
            }
            UriPattern.appendUriPart(sb, path, 5, values, encode);
        }
        if (query != null && query.length() > 0) {
            sb.append('?');
            UriPattern.appendUriPart(sb, query, 6, values, encode);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            UriPattern.appendUriPart(sb, fragment, 7, values, encode);
        }
        return sb.toString();
    }

    public static String createUriWithValues(String schema, String userInfo, String host, int port, String path, String query, String fragment, Object[] values, boolean encode) {
        HashMap<String, String> m = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        int p = 0;
        if (schema != null) {
            p = UriPattern.appendUriPart(sb, schema, 0, values, p, m, false);
            sb.append(':');
        }
        if (userInfo != null || host != null || port != -1) {
            sb.append('/').append('/');
            if (userInfo != null && userInfo.length() > 0) {
                p = UriPattern.appendUriPart(sb, userInfo, 1, values, p, m, encode);
                sb.append('@');
            }
            if (host != null) {
                p = UriPattern.appendUriPart(sb, host, 2, values, p, m, encode);
            }
            if (port != -1) {
                sb.append(':');
                p = UriPattern.appendUriPart(sb, "" + port, 3, values, p, m, encode);
            }
        }
        if (path != null) {
            if (sb.length() > 0 && path.length() > 0 && path.charAt(0) != '/') {
                sb.append('/');
            }
            p = UriPattern.appendUriPart(sb, path, 5, values, p, m, encode);
        }
        if (query != null && query.length() > 0) {
            sb.append('?');
            p = UriPattern.appendUriPart(sb, query, 6, values, p, m, encode);
        }
        if (fragment != null && fragment.length() > 0) {
            sb.append('#');
            p = UriPattern.appendUriPart(sb, fragment, 7, values, p, m, encode);
        }
        return sb.toString();
    }

    private static void appendUriPart(StringBuilder sb, String uriPart, int component, Map<String, ? extends Object> values, boolean encode) {
        if (!UriPattern.hasUriTemplates(uriPart)) {
            sb.append(uriPart);
            return;
        }
        Matcher m = UriTemplateParser.URI_PARAMETERS_PATTERN.matcher(uriPart);
        int start = 0;
        while (m.find()) {
            sb.append(uriPart, start, m.start());
            String param = uriPart.substring(m.start() + 1, m.end() - 1);
            Object o = values.get(param);
            if (o == null) {
                throw new IllegalArgumentException("Not found corresponding value for parameter " + param);
            }
            String value = o.toString();
            sb.append(encode ? UriComponent.encode(value, component, true) : UriComponent.recognizeEncode(value, component, true));
            start = m.end();
        }
        sb.append(uriPart, start, uriPart.length());
    }

    private static int appendUriPart(StringBuilder sb, String uriPart, int component, Object[] sourceValues, int offset, Map<String, String> values, boolean encode) {
        if (!UriPattern.hasUriTemplates(uriPart)) {
            sb.append(uriPart);
            return offset;
        }
        Matcher m = UriTemplateParser.URI_PARAMETERS_PATTERN.matcher(uriPart);
        int start = 0;
        while (m.find()) {
            sb.append(uriPart, start, m.start());
            String param = uriPart.substring(m.start() + 1, m.end() - 1);
            String value = values.get(param);
            if (value != null) {
                sb.append(value);
            } else {
                if (offset < sourceValues.length) {
                    value = sourceValues[offset++].toString();
                }
                if (value != null) {
                    value = encode ? UriComponent.encode(value, component, true) : UriComponent.recognizeEncode(value, component, true);
                    values.put(param, value);
                    sb.append(value);
                } else {
                    throw new IllegalArgumentException("Not found corresponding value for parameter " + param);
                }
            }
            start = m.end();
        }
        sb.append(uriPart, start, uriPart.length());
        return offset;
    }

    private static boolean hasUriTemplates(String uri) {
        return uri.indexOf(123) != -1;
    }

    private static final class UriPatternComparator
    implements Comparator<UriPattern> {
        private UriPatternComparator() {
        }

        @Override
        public int compare(UriPattern o1, UriPattern o2) {
            if (o1 == null & o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if ("".equals(o1.getTemplate()) && "".equals(o2.getTemplate())) {
                return 0;
            }
            if ("".equals(o1.getTemplate())) {
                return 1;
            }
            if ("".equals(o2.getTemplate())) {
                return -1;
            }
            if (o1.getNumberOfLiteralCharacters() < o2.getNumberOfLiteralCharacters()) {
                return 1;
            }
            if (o1.getNumberOfLiteralCharacters() > o2.getNumberOfLiteralCharacters()) {
                return -1;
            }
            if (o1.getParameterNames().size() < o2.getParameterNames().size()) {
                return 1;
            }
            if (o1.getParameterNames().size() > o2.getParameterNames().size()) {
                return -1;
            }
            return o1.getRegex().compareTo(o2.getRegex());
        }
    }
}

