/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.async;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.async.AsynchronousJob;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.async.AsynchronousProcess;

@Path(value="async")
public class AsynchronousJobService {
    @Context
    private Providers providers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{job}")
    public Object get(@PathParam(value="job") String jobId, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        AsynchronousJobPool pool = this.getJobPool();
        AsynchronousJob job = pool.getJob(jobId);
        if (job == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Job " + jobId + " not found. ")).type("text/plain").build());
        }
        GenericContainerRequest request = (GenericContainerRequest)job.getContext().get("org.everrest.async.request");
        if (securityContext.isUserInRole("administrators") || this.principalMatched(request.getUserPrincipal(), securityContext.getUserPrincipal())) {
            if (job.isDone()) {
                Response response;
                Object result;
                try {
                    result = job.getResult();
                }
                finally {
                    pool.removeJob(jobId);
                    ApplicationContextImpl.getCurrent().setProviders((ProviderBinder)job.getContext().get("org.everrest.async.providers"));
                }
                if (result == null || result.getClass() == Void.TYPE || result.getClass() == Void.class) {
                    response = Response.noContent().build();
                } else if (Response.class.isAssignableFrom(result.getClass())) {
                    response = (Response)result;
                    if (response.getEntity() != null && response.getMetadata().getFirst((Object)"Content-Type") == null) {
                        MediaType contentType = request.getAcceptableMediaType(job.getResourceMethod().produces());
                        response.getMetadata().putSingle((Object)"Content-Type", (Object)contentType);
                    }
                } else {
                    MediaType contentType = request.getAcceptableMediaType(job.getResourceMethod().produces());
                    response = Response.ok((Object)result, (MediaType)contentType).build();
                }
                ApplicationContextImpl.getCurrent().getContainerResponse().setResponse(response);
                return null;
            }
            String jobUri = uriInfo.getRequestUri().toString();
            return Response.status((Response.Status)Response.Status.ACCEPTED).header("Location", (Object)jobUri).entity((Object)jobUri).type("text/plain").build();
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("GET: (" + jobId + ") - Operation not permitted. ")).type("text/plain").build());
    }

    @GET
    @Produces(value={"application/json", "text/plain"})
    public GenericEntity<List<AsynchronousProcess>> list() {
        AsynchronousJobPool pool = this.getJobPool();
        List<AsynchronousJob> jobs = pool.getAll();
        ArrayList<AsynchronousProcess> processes = new ArrayList<AsynchronousProcess>(jobs.size());
        for (AsynchronousJob job : jobs) {
            GenericContainerRequest request = (GenericContainerRequest)job.getContext().get("org.everrest.async.request");
            Principal principal = request.getUserPrincipal();
            processes.add(new AsynchronousProcess(principal != null ? principal.getName() : null, job.getJobId(), request.getRequestUri().getPath(), job.isDone() ? "done" : "running"));
        }
        return new GenericEntity<List<AsynchronousProcess>>(processes){};
    }

    @DELETE
    @Path(value="{job}")
    public void remove(@PathParam(value="job") String jobId, @Context SecurityContext securityContext) {
        AsynchronousJobPool pool = this.getJobPool();
        AsynchronousJob job = pool.getJob(jobId);
        if (job == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Job " + jobId + " not found. ")).type("text/plain").build());
        }
        if (!securityContext.isUserInRole("administrators") && !this.principalMatched(((GenericContainerRequest)job.getContext().get("org.everrest.async.request")).getUserPrincipal(), securityContext.getUserPrincipal())) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("DELETE: (" + jobId + ") - Operation not permitted. ")).type("text/plain").build());
        }
        pool.removeJob(jobId);
    }

    private boolean principalMatched(Principal principal1, Principal principal2) {
        if (principal1 == null) {
            return true;
        }
        if (principal2 != null) {
            String name1 = principal1.getName();
            String name2 = principal2.getName();
            if (name1 == null && name2 == null || name1 != null && name1.equals(name2)) {
                return true;
            }
        }
        return false;
    }

    private AsynchronousJobPool getJobPool() {
        ContextResolver asyncJobsResolver;
        if (this.providers != null && (asyncJobsResolver = this.providers.getContextResolver(AsynchronousJobPool.class, null)) != null) {
            return (AsynchronousJobPool)asyncJobsResolver.getContext(null);
        }
        throw new IllegalStateException("Asynchronous jobs feature is not configured properly. ");
    }
}

