/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core;

import java.util.ArrayList;
import java.util.List;
import org.everrest.core.ApplicationContext;
import org.everrest.core.ConstructorDescriptor;
import org.everrest.core.FieldInjector;
import org.everrest.core.Lifecycle;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ObjectModel;
import org.everrest.core.impl.LifecycleComponent;

public class PerRequestObjectFactory<T extends ObjectModel>
implements ObjectFactory<T> {
    protected final T model;

    public PerRequestObjectFactory(T model) {
        this.model = model;
    }

    @Override
    public Object getInstance(ApplicationContext context) {
        ConstructorDescriptor inj = this.model.getConstructorDescriptors().get(0);
        Object object = inj.createInstance(context);
        List<FieldInjector> fieldInjectors = this.model.getFieldInjectors();
        if (fieldInjectors != null && fieldInjectors.size() > 0) {
            for (FieldInjector injector : fieldInjectors) {
                injector.inject(object, context);
            }
        }
        this.doPostConstruct(object, context);
        return object;
    }

    protected final void doPostConstruct(Object object, ApplicationContext context) {
        if (context instanceof Lifecycle) {
            LifecycleComponent lc = new LifecycleComponent(object);
            lc.initialize();
            ArrayList<LifecycleComponent> perRequest = (ArrayList<LifecycleComponent>)context.getAttributes().get("org.everrest.lifecycle.PerRequest");
            if (perRequest == null) {
                perRequest = new ArrayList<LifecycleComponent>();
                context.getAttributes().put("org.everrest.lifecycle.PerRequest", perRequest);
            }
            perRequest.add(lc);
        }
    }

    @Override
    public T getObjectModel() {
        return this.model;
    }
}

