/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;

public final class FileCollector {
    private static final String PREF = "everrest";
    private static final String SUFF = ".tmp";
    private final File store;
    private final Thread cleaner = new Thread(){

        @Override
        public void run() {
            FileCollector.this.clean();
        }
    };

    public static FileCollector getInstance() {
        return FileCollectorHolder.collector;
    }

    private FileCollector(File store) {
        this.store = store;
        try {
            Runtime.getRuntime().addShutdownHook(this.cleaner);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void clean() {
        if (this.store.exists()) {
            this.delete(this.store);
        }
    }

    public void stop() {
        this.clean();
        try {
            Runtime.getRuntime().removeShutdownHook(this.cleaner);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public File createFile(String fileName) throws IOException {
        this.checkStore();
        return new File(this.store, fileName);
    }

    public File createFile() throws IOException {
        this.checkStore();
        return File.createTempFile(PREF, SUFF, this.store);
    }

    public File getStore() {
        this.checkStore();
        return this.store;
    }

    private void checkStore() {
        if (!this.store.exists()) {
            this.store.mkdirs();
        }
    }

    private void delete(File fileOrDirectory) {
        File[] children;
        if (fileOrDirectory.isDirectory() && (children = fileOrDirectory.listFiles()).length > 0) {
            for (File ch : children) {
                this.delete(ch);
            }
        }
        fileOrDirectory.delete();
    }

    private static class FileCollectorHolder {
        private static final String name = "everrest" + Long.toString(Math.abs(new SecureRandom().nextLong()));
        private static final FileCollector collector = new FileCollector(new File(System.getProperty("java.io.tmpdir"), name));

        private FileCollectorHolder() {
        }
    }
}

