/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.everrest.core.LifecycleMethodStrategy;
import org.everrest.core.impl.HelperCache;
import org.everrest.core.impl.InternalException;

public final class AnnotatedLifecycleMethodStrategy
implements LifecycleMethodStrategy {
    private static final MethodFilter POST_CONSTRUCT_METHOD_FILTER = new MethodFilter(PostConstruct.class);
    private static final MethodFilter PRE_DESTROY_METHOD_FILTER = new MethodFilter(PreDestroy.class);
    private final HelperCache<Class<?>, Method[]> initializeMethodsCache = new HelperCache(60000L, 250);
    private final HelperCache<Class<?>, Method[]> destroyMethodsCache = new HelperCache(60000L, 250);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeInitializeMethods(Object o) {
        Method[] initMethods;
        Class<?> clazz = o.getClass();
        HelperCache<Class<?>, Method[]> helperCache = this.initializeMethodsCache;
        synchronized (helperCache) {
            initMethods = this.initializeMethodsCache.get(clazz);
            if (initMethods == null) {
                initMethods = this.getLifecycleMethods(clazz, POST_CONSTRUCT_METHOD_FILTER);
                this.initializeMethodsCache.put(clazz, initMethods);
            }
        }
        if (initMethods.length > 0) {
            this.doInvokeLifecycleMethods(o, initMethods);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invokeDestroyMethods(Object o) {
        Method[] destroyMethods;
        Class<?> clazz = o.getClass();
        HelperCache<Class<?>, Method[]> helperCache = this.destroyMethodsCache;
        synchronized (helperCache) {
            destroyMethods = this.destroyMethodsCache.get(clazz);
            if (destroyMethods == null) {
                destroyMethods = this.getLifecycleMethods(clazz, PRE_DESTROY_METHOD_FILTER);
                this.destroyMethodsCache.put(clazz, destroyMethods);
            }
        }
        if (destroyMethods.length > 0) {
            this.doInvokeLifecycleMethods(o, destroyMethods);
        }
    }

    private Method[] getLifecycleMethods(Class<?> cl, MethodFilter filter) {
        try {
            ArrayList<Method> result = new ArrayList<Method>(2);
            while (cl != Object.class) {
                Method[] methods = cl.getDeclaredMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    if (!filter.accept(method)) continue;
                    if (!Modifier.isPublic(method.getModifiers())) {
                        method.setAccessible(true);
                    }
                    result.add(method);
                }
                cl = cl.getSuperclass();
            }
            return result.toArray(new Method[result.size()]);
        }
        catch (SecurityException e) {
            throw new InternalException(e);
        }
    }

    private void doInvokeLifecycleMethods(Object o, Method[] lifecycleMethods) {
        for (Method method : lifecycleMethods) {
            try {
                method.invoke(o, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                throw new InternalException(t);
            }
            catch (Exception e) {
                throw new InternalException(e);
            }
        }
    }

    private static class MethodFilter {
        private final Class<? extends Annotation> annotation;

        MethodFilter(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        boolean accept(Method m) {
            return !Modifier.isStatic(m.getModifiers()) && (m.getReturnType() == Void.TYPE || m.getReturnType() == Void.class) && m.getParameterTypes().length == 0 && this.noCheckedException(m) && m.getAnnotation(this.annotation) != null;
        }

        private boolean noCheckedException(Method m) {
            Class<?>[] exceptions = m.getExceptionTypes();
            if (exceptions.length > 0) {
                for (int i = 0; i < exceptions.length; ++i) {
                    if (RuntimeException.class.isAssignableFrom(exceptions[i])) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

