/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.everrest.core.DependencySupplier;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.Lifecycle;
import org.everrest.core.RequestHandler;
import org.everrest.core.ResourceBinder;
import org.everrest.core.UnhandledException;
import org.everrest.core.impl.ApplicationPublisher;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.LifecycleComponent;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.RequestDispatcher;
import org.everrest.core.impl.RequestHandlerImpl;
import org.everrest.core.util.Logger;

public final class EverrestProcessor
implements Lifecycle {
    private static final Logger LOG = Logger.getLogger(EverrestProcessor.class.getName());
    private final RequestHandler requestHandler;
    private final ResourceBinder resources;
    private final ProviderBinder providers;
    private final List<WeakReference<Object>> singletonsReferences = new ArrayList<WeakReference<Object>>();

    public EverrestProcessor(ResourceBinder resources, ProviderBinder providers, DependencySupplier dependencies, EverrestConfiguration config, Application application) {
        this(new RequestHandlerImpl(new RequestDispatcher(resources), providers, dependencies, config), resources, providers, application);
    }

    public EverrestProcessor(RequestHandler handler, ResourceBinder resources, ProviderBinder providers, Application application) {
        this.resources = resources;
        this.providers = providers;
        this.requestHandler = handler;
        if (application != null) {
            this.addApplication(application);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GenericContainerRequest request, GenericContainerResponse response, EnvironmentContext envCtx) throws UnhandledException, IOException {
        try {
            EnvironmentContext.setCurrent(envCtx);
            this.requestHandler.handleRequest(request, response);
        }
        finally {
            EnvironmentContext.setCurrent(null);
        }
    }

    public void addApplication(Application application) {
        if (application == null) {
            throw new NullPointerException("application");
        }
        new ApplicationPublisher(this.resources, this.providers).publish(application);
        Set singletons = application.getSingletons();
        if (singletons != null && singletons.size() > 0) {
            for (Object o : singletons) {
                this.singletonsReferences.add(new WeakReference(o));
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        for (WeakReference<Object> ref : this.singletonsReferences) {
            Object o = ref.get();
            if (o == null) continue;
            try {
                new LifecycleComponent(o).destroy();
            }
            catch (InternalException e) {
                LOG.error("Unable to destroy component. ", e);
            }
        }
        this.singletonsReferences.clear();
    }
}

