/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.header;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.everrest.core.impl.header.HeaderHelper;

public class HeaderParameterParser {
    private static final char SEPARATOR = ';';
    private int pos = 0;
    private int i1 = 0;
    private int i2 = 0;
    private char[] chars = null;
    private int length = 0;

    public Map<String, String> parse(String header) throws ParseException {
        this.init(header);
        if (this.pos < 0) {
            return null;
        }
        ++this.pos;
        HashMap<String, String> m = null;
        while (this.hasChars()) {
            String name = this.readToken(new char[]{'=', ';'});
            String value = null;
            if (this.hasChars() && this.chars[this.pos] == '=') {
                ++this.pos;
                value = this.chars[this.pos] == '\"' ? this.readQuotedString() : this.readToken(new char[]{';'});
            }
            if (this.hasChars() && this.chars[this.pos] == ';') {
                ++this.pos;
            }
            if (name == null || name.length() <= 0) continue;
            if (m == null) {
                m = new HashMap<String, String>();
            }
            m.put(name, value);
        }
        return m;
    }

    private String getToken(boolean removeQuotes) {
        while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
            ++this.i1;
        }
        while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
            --this.i2;
        }
        if (removeQuotes && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
            ++this.i1;
            --this.i2;
        }
        String token = null;
        if (this.i2 > this.i1) {
            token = new String(this.chars, this.i1, this.i2 - this.i1);
        }
        return token;
    }

    private boolean hasChars() {
        return this.pos < this.length;
    }

    private void init(String source) {
        this.pos = source.indexOf(59);
        if (this.pos < 0) {
            return;
        }
        this.chars = source.toCharArray();
        this.length = this.chars.length;
        this.i1 = 0;
        this.i2 = 0;
    }

    private String readQuotedString() throws ParseException {
        char c;
        this.i1 = this.pos;
        this.i2 = this.pos;
        boolean escape = false;
        boolean quote = false;
        while (this.hasChars() && ((c = this.chars[this.pos]) != ';' || quote)) {
            if (c == '\"' && !escape) {
                quote = !quote;
            }
            escape = !escape && c == '\\';
            ++this.pos;
            ++this.i2;
        }
        if (quote) {
            throw new ParseException("String must be ended with quote.", this.pos);
        }
        String token = this.getToken(true);
        if (token != null) {
            token = HeaderHelper.filterEscape(this.getToken(true));
        }
        return token;
    }

    private String readToken(char[] terminators) throws ParseException {
        int err;
        char c;
        this.i1 = this.pos;
        this.i2 = this.pos;
        while (this.hasChars() && !this.checkChar(c = this.chars[this.pos], terminators)) {
            ++this.pos;
            ++this.i2;
        }
        String token = this.getToken(false);
        if (token != null && (err = HeaderHelper.isToken(token)) != -1) {
            throw new ParseException("Token '" + token + "' contains not legal characters at " + err, err);
        }
        return token;
    }

    private boolean checkChar(char c, char[] chs) {
        for (int i = 0; i < chs.length; ++i) {
            if (c != chs[i]) continue;
            return true;
        }
        return false;
    }
}

