/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.json;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.everrest.core.impl.provider.json.JsonTransient;

public final class JsonUtils {
    static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final Map<String, Types> KNOWN_TYPES = new HashMap<String, Types>();

    public static String getJsonString(String string) {
        char[] charArray;
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        block9: for (char c : charArray = string.toCharArray()) {
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                default: {
                    if (c < '\u0010') {
                        sb.append("\\u000").append(Integer.toHexString(c));
                        continue block9;
                    }
                    if (c < ' ' && c > '\t' || c >= '\u0080' && c < '\u00a0') {
                        sb.append("\\u00").append(Integer.toHexString(c));
                        continue block9;
                    }
                    if (c >= '\u2000' && c < '\u2100') {
                        sb.append("\\u").append(Integer.toHexString(c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    public static boolean isKnownType(Object o) {
        return o == null || JsonUtils.isKnownType(o.getClass());
    }

    public static boolean isKnownType(Class<?> clazz) {
        return KNOWN_TYPES.get(clazz.getName()) != null;
    }

    public static Types getType(Object o) {
        if (o == null) {
            return Types.NULL;
        }
        if (KNOWN_TYPES.get(o.getClass().getName()) != null) {
            return KNOWN_TYPES.get(o.getClass().getName());
        }
        if (o instanceof Enum) {
            return Types.ENUM;
        }
        if (o instanceof Object[]) {
            return Types.ARRAY_OBJECT;
        }
        if (o instanceof Collection) {
            return Types.COLLECTION;
        }
        if (o instanceof Map) {
            return Types.MAP;
        }
        return null;
    }

    public static Types getType(Class<?> clazz) {
        if (KNOWN_TYPES.get(clazz.getName()) != null) {
            return KNOWN_TYPES.get(clazz.getName());
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return Types.ENUM;
        }
        if (clazz.isArray()) {
            return Types.ARRAY_OBJECT;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Types.COLLECTION;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Types.MAP;
        }
        return null;
    }

    public static Set<String> getTransientFields(Class<?> clazz) {
        Field[] fields;
        HashSet<String> set = new HashSet<String>();
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (!Modifier.isTransient(f.getModifiers()) && f.getAnnotation(JsonTransient.class) == null) continue;
            set.add(f.getName());
        }
        return set;
    }

    public static <T> T createProxy(Class<T> interf) {
        if (interf == null) {
            throw new NullPointerException();
        }
        if (!interf.isInterface()) {
            throw new IllegalArgumentException("Type '" + interf.getSimpleName() + "' is not interface. ");
        }
        return (T)Proxy.newProxyInstance(interf.getClassLoader(), new Class[]{interf}, (InvocationHandler)new ProxyObject(interf));
    }

    private JsonUtils() {
    }

    static {
        KNOWN_TYPES.put(Boolean.class.getName(), Types.BOOLEAN);
        KNOWN_TYPES.put(Byte.class.getName(), Types.BYTE);
        KNOWN_TYPES.put(Short.class.getName(), Types.SHORT);
        KNOWN_TYPES.put(Integer.class.getName(), Types.INT);
        KNOWN_TYPES.put(Long.class.getName(), Types.LONG);
        KNOWN_TYPES.put(Float.class.getName(), Types.FLOAT);
        KNOWN_TYPES.put(Double.class.getName(), Types.DOUBLE);
        KNOWN_TYPES.put(Character.class.getName(), Types.CHAR);
        KNOWN_TYPES.put(String.class.getName(), Types.STRING);
        KNOWN_TYPES.put(Class.class.getName(), Types.CLASS);
        KNOWN_TYPES.put("boolean", Types.BOOLEAN);
        KNOWN_TYPES.put("byte", Types.BYTE);
        KNOWN_TYPES.put("short", Types.SHORT);
        KNOWN_TYPES.put("int", Types.INT);
        KNOWN_TYPES.put("long", Types.LONG);
        KNOWN_TYPES.put("float", Types.FLOAT);
        KNOWN_TYPES.put("double", Types.DOUBLE);
        KNOWN_TYPES.put("char", Types.CHAR);
        KNOWN_TYPES.put("null", Types.NULL);
        KNOWN_TYPES.put(boolean[].class.getName(), Types.ARRAY_BOOLEAN);
        KNOWN_TYPES.put(byte[].class.getName(), Types.ARRAY_BYTE);
        KNOWN_TYPES.put(short[].class.getName(), Types.ARRAY_SHORT);
        KNOWN_TYPES.put(int[].class.getName(), Types.ARRAY_INT);
        KNOWN_TYPES.put(long[].class.getName(), Types.ARRAY_LONG);
        KNOWN_TYPES.put(double[].class.getName(), Types.ARRAY_DOUBLE);
        KNOWN_TYPES.put(float[].class.getName(), Types.ARRAY_FLOAT);
        KNOWN_TYPES.put(char[].class.getName(), Types.ARRAY_CHAR);
        KNOWN_TYPES.put(String[].class.getName(), Types.ARRAY_STRING);
    }

    private static final class ProxyObject
    implements InvocationHandler {
        private final Map<String, Object> values = new HashMap<String, Object>();
        private final Class<?> interf;

        private ProxyObject(Class<?> interf) {
            this.interf = interf;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String key = this.key(method);
            if (key != null) {
                if (args == null) {
                    return this.value(key, method);
                }
                this.values.put(key, args[0]);
                return null;
            }
            if ("toString".equals(method.getName())) {
                StringBuilder buf = new StringBuilder();
                buf.append('{');
                Method[] allMethods = this.interf.getMethods();
                int length = allMethods.length;
                for (int i = 0; i < length; ++i) {
                    if (allMethods[i].getParameterTypes().length != 0 || (key = this.key(allMethods[i])) == null) continue;
                    if (i > 0) {
                        buf.append(',');
                        buf.append(' ');
                    }
                    buf.append(key);
                    buf.append('=');
                    buf.append(this.value(key, allMethods[i]));
                }
                return buf.append('}').toString();
            }
            return null;
        }

        private Object value(String key, Method method) {
            Object value = this.values.get(key);
            if (value != null) {
                return value;
            }
            Class<?> valueType = method.getReturnType();
            if (valueType.isPrimitive()) {
                if (Boolean.TYPE == valueType) {
                    return false;
                }
                if (Byte.TYPE == valueType) {
                    return (byte)0;
                }
                if (Short.TYPE == valueType) {
                    return (short)0;
                }
                if (Character.TYPE == valueType) {
                    return Character.valueOf('\u0000');
                }
                if (Integer.TYPE == valueType) {
                    return 0;
                }
                if (Long.TYPE == valueType) {
                    return 0L;
                }
                if (Float.TYPE == valueType) {
                    return Float.valueOf(0.0f);
                }
                if (Double.TYPE == valueType) {
                    return 0.0;
                }
            }
            return null;
        }

        private String key(Method method) {
            String name = method.getName();
            Class<?>[] parameters = method.getParameterTypes();
            if ("getClass".equals(name) || "getMetaClass".equals(name) || "setMetaClass".equals(name) || parameters.length > 1) {
                return null;
            }
            String key = null;
            if (parameters.length == 1) {
                if (name.startsWith("set") && name.length() > 3) {
                    key = name.substring(3);
                }
            } else if (name.startsWith("get") && name.length() > 3) {
                key = name.substring(3);
            } else if (name.startsWith("is") && name.length() > 2 && method.getReturnType() == Boolean.TYPE) {
                key = name.substring(2);
            }
            if (key != null) {
                key = key.length() > 1 ? Character.toLowerCase(key.charAt(0)) + key.substring(1) : key.toLowerCase();
            }
            return key;
        }
    }

    public static enum JsonToken {
        object,
        array,
        key,
        value;

    }

    public static enum Types {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        CHAR,
        STRING,
        NULL,
        ARRAY_BYTE,
        ARRAY_SHORT,
        ARRAY_INT,
        ARRAY_LONG,
        ARRAY_FLOAT,
        ARRAY_DOUBLE,
        ARRAY_BOOLEAN,
        ARRAY_CHAR,
        ARRAY_STRING,
        ARRAY_OBJECT,
        COLLECTION,
        MAP,
        ENUM,
        CLASS;

    }
}

