/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.InputHeadersMap;
import org.everrest.core.impl.MultivaluedMapImpl;

public final class ServletContainerRequest
extends ContainerRequest {
    public ServletContainerRequest(final HttpServletRequest req) {
        super(ServletContainerRequest.getMethod(req), ServletContainerRequest.getRequestUri(req), ServletContainerRequest.getBaseUri(req), ServletContainerRequest.getEntityStream(req), ServletContainerRequest.getHeader(req), new SecurityContext(){

            public Principal getUserPrincipal() {
                return req.getUserPrincipal();
            }

            public boolean isUserInRole(String role) {
                return req.isUserInRole(role);
            }

            public boolean isSecure() {
                return req.isSecure();
            }

            public String getAuthenticationScheme() {
                return req.getAuthType();
            }
        });
    }

    private static String getMethod(HttpServletRequest servletRequest) {
        return servletRequest.getMethod();
    }

    private static URI getRequestUri(HttpServletRequest servletRequest) {
        UriBuilder baseBuilder = UriBuilder.fromUri((URI)ServletContainerRequest.getBaseUri(servletRequest));
        return baseBuilder.replacePath(servletRequest.getRequestURI()).replaceQuery(servletRequest.getQueryString()).build(new Object[0]);
    }

    private static URI getBaseUri(HttpServletRequest servletRequest) {
        String scheme = servletRequest.getScheme();
        String server = scheme + "://" + servletRequest.getServerName();
        UriBuilder builder = UriBuilder.fromUri((String)server);
        int port = servletRequest.getServerPort();
        if (!(port == 80 || port == 443 && "https".equals(scheme))) {
            builder.port(port);
        }
        builder.path(servletRequest.getContextPath() + servletRequest.getServletPath());
        return builder.build(new Object[0]);
    }

    private static MultivaluedMap<String, String> getHeader(HttpServletRequest servletRequest) {
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        Enumeration headerNames = servletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration e = servletRequest.getHeaders(name);
            while (e.hasMoreElements()) {
                h.add(name, (String)e.nextElement());
            }
        }
        return new InputHeadersMap(h);
    }

    private static InputStream getEntityStream(HttpServletRequest servletRequest) {
        try {
            return servletRequest.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

