/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.everrest.core.impl.provider.JAXBContextResolver;
import org.everrest.core.provider.EntityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Consumes(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
@Produces(value={"application/xml", "application/*+xml", "text/xml", "text/*+xml"})
public class JAXBElementEntityProvider
implements EntityProvider<JAXBElement<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(JAXBElementEntityProvider.class);
    private Providers providers;

    public JAXBElementEntityProvider(@Context Providers providers) {
        this.providers = providers;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == JAXBElement.class && genericType instanceof ParameterizedType;
    }

    public JAXBElement<?> readFrom(Class<JAXBElement<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ParameterizedType pt = (ParameterizedType)genericType;
        Class c = (Class)pt.getActualTypeArguments()[0];
        try {
            JAXBContext jaxbContext = this.getJAXBContext(c, mediaType);
            return jaxbContext.createUnmarshaller().unmarshal((Source)new StreamSource(entityStream), c);
        }
        catch (UnmarshalException e) {
            if (LOG.isDebugEnabled()) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
        catch (JAXBException e) {
            throw new IOException("Can't read from input stream " + (Object)((Object)e));
        }
    }

    public long getSize(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JAXBElement.class.isAssignableFrom(type);
    }

    public void writeTo(JAXBElement<?> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Class c = t.getDeclaredType();
        try {
            String charset;
            JAXBContext jaxbContext = this.getJAXBContext(c, mediaType);
            Marshaller m = jaxbContext.createMarshaller();
            String string = charset = mediaType == null ? null : (String)mediaType.getParameters().get("charset");
            if (charset != null) {
                m.setProperty("jaxb.encoding", (Object)charset);
            }
            m.marshal(t, entityStream);
        }
        catch (JAXBException e) {
            throw new IOException("Can't write to output stream " + (Object)((Object)e));
        }
    }

    protected JAXBContext getJAXBContext(Class<?> type, MediaType mediaType) throws JAXBException {
        ContextResolver resolver = this.providers.getContextResolver(JAXBContextResolver.class, mediaType);
        if (resolver == null) {
            throw new RuntimeException("Not found any JAXBContextResolver for media type " + mediaType);
        }
        JAXBContextResolver jaxbContextResolver = (JAXBContextResolver)resolver.getContext(null);
        return jaxbContextResolver.getJAXBContext(type);
    }
}

