/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.tools;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;

public class SimpleSecurityContext
implements SecurityContext {
    private final String authenticationScheme;
    private final Principal principal;
    private final Set<String> userRoles;
    private final boolean secure;

    public SimpleSecurityContext(Principal principal, Set<String> userRoles, String authenticationScheme, boolean secure) {
        this.principal = principal;
        this.authenticationScheme = authenticationScheme;
        this.secure = secure;
        this.userRoles = userRoles == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(userRoles));
    }

    public SimpleSecurityContext(boolean secure) {
        this(null, null, null, secure);
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isUserInRole(String role) {
        return this.principal != null && this.userRoles.contains(role);
    }

    public Set<String> getUserRoles() {
        return this.userRoles;
    }
}

