/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.header;

import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.ext.RuntimeDelegate;
import org.everrest.core.impl.header.AcceptLanguage;
import org.everrest.core.impl.header.HeaderHelper;
import org.everrest.core.impl.header.HeaderParameterParser;
import org.everrest.core.impl.header.Language;

public class AcceptLanguageHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<AcceptLanguage> {
    public AcceptLanguage fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        try {
            String primaryTag;
            String tag;
            header = HeaderHelper.removeWhitespaces(header);
            Map<String, String> m = null;
            int p = header.indexOf(59);
            if (p != -1 && p < header.length() - 1) {
                tag = header.substring(0, p);
                m = new HeaderParameterParser().parse(header);
            } else {
                tag = header;
            }
            p = tag.indexOf(45);
            String subTag = null;
            if (p != -1 && p < tag.length() - 1) {
                primaryTag = tag.substring(0, p);
                subTag = tag.substring(p + 1);
            } else {
                primaryTag = tag;
            }
            if (m == null) {
                return new AcceptLanguage(new Locale(primaryTag, subTag != null ? subTag : ""));
            }
            return new AcceptLanguage(new Locale(primaryTag, subTag != null ? subTag : ""), HeaderHelper.parseQualityValue(m.get("q")));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Accept language header malformed");
        }
    }

    public String toString(AcceptLanguage language) {
        if (language == null) {
            throw new IllegalArgumentException();
        }
        return new Language(language.getLocale()).toString();
    }
}

