/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.FileCollector;
import org.everrest.core.impl.provider.IOHelper;
import org.everrest.core.provider.EntityProvider;

@Provider
public class DataSourceEntityProvider
implements EntityProvider<DataSource> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == DataSource.class;
    }

    public DataSource readFrom(Class<DataSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        String m = mediaType == null ? null : mediaType.toString();
        return DataSourceEntityProvider.createDataSource(entityStream, m);
    }

    public long getSize(DataSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    public void writeTo(DataSource t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (InputStream in = t.getInputStream();){
            IOHelper.write(in, entityStream);
        }
    }

    private static DataSource createDataSource(InputStream entityStream, String mimeType) throws IOException {
        int bytes;
        boolean overflow = false;
        byte[] buffer = new byte[8192];
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        int bufferSize = context.getEverrestConfiguration().getMaxBufferSize();
        ByteArrayOutputStream bout = new ByteArrayOutputStream(bufferSize);
        while (!overflow && (bytes = entityStream.read(buffer)) != -1) {
            bout.write(buffer, 0, bytes);
            if (bout.size() <= bufferSize) continue;
            overflow = true;
        }
        if (!overflow) {
            return new ByteArrayDataSource(bout.toByteArray(), mimeType);
        }
        File file = FileCollector.getInstance().createFile();
        FileOutputStream fos = new FileOutputStream(file);
        bout.writeTo(fos);
        while ((bytes = entityStream.read(buffer)) != -1) {
            ((OutputStream)fos).write(buffer, 0, bytes);
        }
        ((OutputStream)fos).close();
        return new MimeFileDataSource(file, mimeType);
    }

    static class MimeFileDataSource
    extends FileDataSource {
        private final String mimeType;

        public MimeFileDataSource(File file, String mimeType) {
            super(file);
            this.mimeType = mimeType;
        }

        protected void finalize() throws Throwable {
            File file = this.getFile();
            if (file.exists()) {
                file.delete();
            }
            super.finalize();
        }

        public String getContentType() {
            return this.mimeType;
        }
    }
}

