/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.json;

import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.everrest.core.impl.HelperCache;
import org.everrest.core.impl.provider.json.ArrayValue;
import org.everrest.core.impl.provider.json.BooleanValue;
import org.everrest.core.impl.provider.json.DoubleValue;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonMethod;
import org.everrest.core.impl.provider.json.JsonParser;
import org.everrest.core.impl.provider.json.JsonUtils;
import org.everrest.core.impl.provider.json.JsonValue;
import org.everrest.core.impl.provider.json.LongValue;
import org.everrest.core.impl.provider.json.NullValue;
import org.everrest.core.impl.provider.json.ObjectValue;
import org.everrest.core.impl.provider.json.StringValue;

public class JsonGenerator {
    private static final Collection<String> SKIP_METHODS = new HashSet<String>();
    private static final int CACHE_NUM = 8;
    private static final int CACHE_MASK = 7;
    private static HelperCache<Class<?>, JsonMethod[]>[] methodsCache = new HelperCache[8];

    public static JsonValue createJsonArray(Collection<?> collection) throws JsonException {
        return JsonGenerator.createJsonValue(collection);
    }

    public static JsonValue createJsonArray(Object array) throws JsonException {
        if (array == null) {
            return new NullValue();
        }
        JsonUtils.Types t = JsonUtils.getType(array);
        if (t == JsonUtils.Types.ARRAY_BOOLEAN || t == JsonUtils.Types.ARRAY_BYTE || t == JsonUtils.Types.ARRAY_SHORT || t == JsonUtils.Types.ARRAY_INT || t == JsonUtils.Types.ARRAY_LONG || t == JsonUtils.Types.ARRAY_FLOAT || t == JsonUtils.Types.ARRAY_DOUBLE || t == JsonUtils.Types.ARRAY_CHAR || t == JsonUtils.Types.ARRAY_STRING || t == JsonUtils.Types.ARRAY_OBJECT) {
            return JsonGenerator.createJsonValue(array);
        }
        throw new JsonException("Invalid argument, must be array.");
    }

    public static JsonValue createJsonObjectFromMap(Map<String, ?> map) throws JsonException {
        return JsonGenerator.createJsonValue(map);
    }

    public JsonValue createJsonObjectFromString(String s) throws JsonException {
        JsonParser parser = new JsonParser();
        parser.parse(new StringReader(s));
        return parser.getJsonObject();
    }

    public static JsonValue createJsonObject(Object object) throws JsonException {
        Class<?> clazz = object.getClass();
        ObjectValue jsonRootValue = new ObjectValue();
        JsonMethod[] jsonMethods = JsonGenerator.getJsonMethods(clazz);
        if (jsonMethods != null && jsonMethods.length > 0) {
            for (JsonMethod getMethod : jsonMethods) {
                try {
                    Object invokeResult = getMethod.method.invoke(object, new Object[0]);
                    if (JsonUtils.getType(invokeResult) != null) {
                        ((JsonValue)jsonRootValue).addElement(getMethod.field, JsonGenerator.createJsonValue(invokeResult));
                        continue;
                    }
                    ((JsonValue)jsonRootValue).addElement(getMethod.field, JsonGenerator.createJsonObject(invokeResult));
                }
                catch (InvocationTargetException e) {
                    throw new JsonException(e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new JsonException(e.getMessage(), e);
                }
            }
        }
        return jsonRootValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonMethod[] getJsonMethods(Class<?> clazz) {
        HelperCache<Class<?>, JsonMethod[]> partition;
        HelperCache<Class<?>, JsonMethod[]> helperCache = partition = methodsCache[clazz.hashCode() & 7];
        synchronized (helperCache) {
            JsonMethod[] methods = partition.get(clazz);
            if (methods == null) {
                Set<String> transientFieldNames = JsonUtils.getTransientFields(clazz);
                ArrayList<JsonMethod> result = new ArrayList<JsonMethod>();
                for (Method method : clazz.getMethods()) {
                    String methodName = method.getName();
                    if (SKIP_METHODS.contains(methodName) || method.getParameterTypes().length != 0) continue;
                    Class<?> returnType = method.getReturnType();
                    String field = null;
                    if (methodName.startsWith("get") && methodName.length() > 3) {
                        field = methodName.substring(3);
                    } else if (methodName.startsWith("is") && methodName.length() > 2 && (returnType == Boolean.class || returnType == Boolean.TYPE)) {
                        field = methodName.substring(2);
                    }
                    if (field == null) continue;
                    String string = field = field.length() > 1 ? Character.toLowerCase(field.charAt(0)) + field.substring(1) : field.toLowerCase();
                    if (transientFieldNames.contains(field)) continue;
                    result.add(new JsonMethod(method, field));
                }
                methods = result.toArray(new JsonMethod[result.size()]);
                partition.put(clazz, methods);
            }
            return methods;
        }
    }

    private static JsonValue createJsonValue(Object object) throws JsonException {
        JsonUtils.Types type = JsonUtils.getType(object);
        switch (type) {
            case NULL: {
                return new NullValue();
            }
            case BOOLEAN: {
                return new BooleanValue((Boolean)object);
            }
            case BYTE: {
                return new LongValue(((Byte)object).byteValue());
            }
            case SHORT: {
                return new LongValue(((Short)object).shortValue());
            }
            case INT: {
                return new LongValue(((Integer)object).intValue());
            }
            case LONG: {
                return new LongValue((Long)object);
            }
            case FLOAT: {
                return new DoubleValue(((Float)object).floatValue());
            }
            case DOUBLE: {
                return new DoubleValue((Double)object);
            }
            case CHAR: {
                return new StringValue(Character.toString(((Character)object).charValue()));
            }
            case STRING: {
                return new StringValue((String)object);
            }
            case ENUM: {
                return new StringValue(((Enum)object).name());
            }
            case CLASS: {
                return new StringValue(((Class)object).getName());
            }
            case ARRAY_BOOLEAN: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new BooleanValue(Array.getBoolean(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_BYTE: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getByte(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_SHORT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getShort(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_INT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getInt(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_LONG: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new LongValue(Array.getLong(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_FLOAT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new DoubleValue(Array.getFloat(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_DOUBLE: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new DoubleValue(Array.getDouble(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_CHAR: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new StringValue(Character.toString(Array.getChar(object, i))));
                }
                return jsonArray;
            }
            case ARRAY_STRING: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    ((JsonValue)jsonArray).addElement(new StringValue((String)Array.get(object, i)));
                }
                return jsonArray;
            }
            case ARRAY_OBJECT: {
                ArrayValue jsonArray = new ArrayValue();
                int length = Array.getLength(object);
                for (int i = 0; i < length; ++i) {
                    Object el = Array.get(object, i);
                    if (JsonUtils.getType(el) != null) {
                        ((JsonValue)jsonArray).addElement(JsonGenerator.createJsonValue(el));
                        continue;
                    }
                    ((JsonValue)jsonArray).addElement(JsonGenerator.createJsonObject(el));
                }
                return jsonArray;
            }
            case COLLECTION: {
                ArrayValue jsonArray = new ArrayValue();
                ArrayList list = new ArrayList((Collection)object);
                for (Object o : list) {
                    if (JsonUtils.getType(o) != null) {
                        ((JsonValue)jsonArray).addElement(JsonGenerator.createJsonValue(o));
                        continue;
                    }
                    ((JsonValue)jsonArray).addElement(JsonGenerator.createJsonObject(o));
                }
                return jsonArray;
            }
            case MAP: {
                ObjectValue jsonObject = new ObjectValue();
                Map map = (Map)object;
                Set keys = map.keySet();
                for (String k : keys) {
                    Object o = map.get(k);
                    if (JsonUtils.getType(o) != null) {
                        ((JsonValue)jsonObject).addElement(k, JsonGenerator.createJsonValue(o));
                        continue;
                    }
                    ((JsonValue)jsonObject).addElement(k, JsonGenerator.createJsonObject(o));
                }
                return jsonObject;
            }
        }
        return null;
    }

    static {
        SKIP_METHODS.add("getClass");
        SKIP_METHODS.add("getMetaClass");
        for (int i = 0; i < 8; ++i) {
            JsonGenerator.methodsCache[i] = new HelperCache(60000L, 50);
        }
    }
}

