/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import javax.ws.rs.Path;
import org.everrest.core.BaseObjectModel;
import org.everrest.core.FilterDescriptor;
import org.everrest.core.impl.resource.PathValue;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.uri.UriPattern;

public class FilterDescriptorImpl
extends BaseObjectModel
implements FilterDescriptor {
    public static final String DEFAULT_PATH = "/{path:.*}";
    private final PathValue path;
    private final UriPattern uriPattern;

    public FilterDescriptorImpl(Class<?> filterClass) {
        super(filterClass);
        String p = PathValue.getPath(filterClass.getAnnotation(Path.class));
        if (p != null) {
            this.path = new PathValue(p);
            this.uriPattern = new UriPattern(p);
        } else {
            this.path = new PathValue(DEFAULT_PATH);
            this.uriPattern = new UriPattern(DEFAULT_PATH);
        }
    }

    public FilterDescriptorImpl(Object filter) {
        super(filter);
        String p = PathValue.getPath(filter.getClass().getAnnotation(Path.class));
        if (p != null) {
            this.path = new PathValue(p);
            this.uriPattern = new UriPattern(p);
        } else {
            this.path = new PathValue(DEFAULT_PATH);
            this.uriPattern = new UriPattern(DEFAULT_PATH);
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitFilterDescriptor(this);
    }

    @Override
    public PathValue getPathValue() {
        return this.path;
    }

    @Override
    public UriPattern getUriPattern() {
        return this.uriPattern;
    }

    public String toString() {
        return "[ FilterDescriptorImpl: path: " + this.getPathValue() + "; filter class: " + this.getObjectClass() + "; " + this.getConstructorDescriptors() + "; " + this.getFieldInjectors() + " ]";
    }
}

