/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.header;

import javax.ws.rs.core.EntityTag;
import javax.ws.rs.ext.RuntimeDelegate;
import org.everrest.core.impl.header.HeaderHelper;

public class EntityTagHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<EntityTag> {
    public EntityTag fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        boolean isWeak = header.startsWith("W/");
        String value = isWeak ? header.substring(2) : header;
        value = value.substring(1, value.length() - 1);
        value = HeaderHelper.filterEscape(value);
        return new EntityTag(value, isWeak);
    }

    public String toString(EntityTag entityTag) {
        if (entityTag == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        if (entityTag.isWeak()) {
            sb.append('W').append('/');
        }
        sb.append('\"');
        HeaderHelper.appendEscapeQuote(sb, entityTag.getValue());
        sb.append('\"');
        return sb.toString();
    }
}

