/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.json;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.everrest.core.impl.HelperCache;
import org.everrest.core.impl.provider.json.JsonException;
import org.everrest.core.impl.provider.json.JsonMethod;
import org.everrest.core.impl.provider.json.JsonUtils;
import org.everrest.core.impl.provider.json.JsonValue;

public class ObjectBuilder {
    private static final Collection<String> SKIP_METHODS = new HashSet<String>();
    private static final int CACHE_NUM = 8;
    private static final int CACHE_MASK = 7;
    private static HelperCache<Class<?>, Constructor<?>>[] constructorsCache = new HelperCache[8];
    private static HelperCache<Class<?>, JsonMethod[]>[] methodsCache = new HelperCache[8];

    public static Object createArray(Class<?> clazz, JsonValue jsonArray) throws JsonException {
        Object array;
        block10: {
            array = null;
            if (jsonArray == null || jsonArray.isNull()) break block10;
            Class<?> componentType = clazz.getComponentType();
            array = Array.newInstance(componentType, jsonArray.size());
            Iterator<JsonValue> values = jsonArray.getElements();
            int i = 0;
            if (componentType.isArray()) {
                if (JsonUtils.isKnownType(componentType)) {
                    while (values.hasNext()) {
                        JsonValue v = values.next();
                        Array.set(array, i++, ObjectBuilder.createObjectKnownTypes(componentType, v));
                    }
                } else {
                    while (values.hasNext()) {
                        JsonValue v = values.next();
                        Array.set(array, i++, ObjectBuilder.createArray(componentType, v));
                    }
                }
            } else if (JsonUtils.isKnownType(componentType)) {
                while (values.hasNext()) {
                    JsonValue v = values.next();
                    Array.set(array, i++, ObjectBuilder.createObjectKnownTypes(componentType, v));
                }
            } else {
                while (values.hasNext()) {
                    JsonValue v = values.next();
                    Array.set(array, i++, ObjectBuilder.createObject(componentType, v));
                }
            }
        }
        return array;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Collection<?>> T createCollection(Class<T> collectionClass, Type genericType, JsonValue jsonArray) throws JsonException {
        Class elementClass;
        Collection collection = null;
        if (jsonArray == null || jsonArray.isNull()) return (T)collection;
        if (!(genericType instanceof ParameterizedType)) throw new JsonException("Collection is not parameterized. Collection<?> is not supported. ");
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type elementType = parameterizedType.getActualTypeArguments()[0];
        if (elementType instanceof Class) {
            elementClass = (Class)elementType;
        } else {
            if (!(elementType instanceof ParameterizedType)) throw new JsonException("This type of Collection can't be restored from JSON source. \nCollection is parameterized by wrong Type: " + parameterizedType + ".");
            elementClass = (Class)((ParameterizedType)elementType).getRawType();
        }
        Constructor<T> constructor = null;
        if (collectionClass.isInterface() || Modifier.isAbstract(collectionClass.getModifiers())) {
            Class<T> impl = null;
            try {
                impl = ArrayList.class.asSubclass(collectionClass);
            }
            catch (ClassCastException e1) {
                try {
                    impl = HashSet.class.asSubclass(collectionClass);
                }
                catch (ClassCastException e2) {
                    try {
                        impl = LinkedList.class.asSubclass(collectionClass);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (impl != null) {
                constructor = ObjectBuilder.getConstructor(impl, Collection.class);
            }
        } else {
            constructor = ObjectBuilder.getConstructor(collectionClass, Collection.class);
        }
        if (constructor == null) {
            throw new JsonException("Can't find satisfied constructor for : " + collectionClass);
        }
        ArrayList<Object> sourceCollection = new ArrayList<Object>(jsonArray.size());
        Iterator<JsonValue> values = jsonArray.getElements();
        JsonUtils.Types jsonValueType = JsonUtils.getType(elementClass);
        while (values.hasNext()) {
            JsonValue v = values.next();
            if (jsonValueType == null) {
                sourceCollection.add(ObjectBuilder.createObject(elementClass, v));
                continue;
            }
            switch (jsonValueType) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case CHAR: 
                case STRING: 
                case NULL: 
                case ARRAY_BYTE: 
                case ARRAY_SHORT: 
                case ARRAY_INT: 
                case ARRAY_LONG: 
                case ARRAY_FLOAT: 
                case ARRAY_DOUBLE: 
                case ARRAY_BOOLEAN: 
                case ARRAY_CHAR: 
                case ARRAY_STRING: 
                case CLASS: {
                    sourceCollection.add(ObjectBuilder.createObjectKnownTypes(elementClass, v));
                    break;
                }
                case ARRAY_OBJECT: {
                    sourceCollection.add(ObjectBuilder.createArray(elementClass, v));
                    break;
                }
                case COLLECTION: {
                    sourceCollection.add(ObjectBuilder.createCollection(elementClass, elementType, v));
                    break;
                }
                case MAP: {
                    sourceCollection.add(ObjectBuilder.createObject(elementClass, elementType, v));
                    break;
                }
                case ENUM: {
                    sourceCollection.add(ObjectBuilder.createEnum(elementClass, v));
                }
            }
        }
        try {
            collection = (Collection)constructor.newInstance(sourceCollection);
            return (T)collection;
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Map<String, ?>> T createObject(Class<T> mapClass, Type genericType, JsonValue jsonObject) throws JsonException {
        Class valueClass;
        Map map = null;
        if (jsonObject == null || jsonObject.isNull()) return (T)map;
        if (!(genericType instanceof ParameterizedType)) throw new JsonException("Map is not parameterized. Map<Sting, ?> is not supported.");
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        if (!String.class.isAssignableFrom((Class)parameterizedType.getActualTypeArguments()[0])) {
            throw new JsonException("Key of Map must be String. ");
        }
        Type valueType = parameterizedType.getActualTypeArguments()[1];
        if (valueType instanceof Class) {
            valueClass = (Class)valueType;
        } else {
            if (!(valueType instanceof ParameterizedType)) throw new JsonException("This type of Map can't be restored from JSON source.\nMap is parameterized by wrong Type: " + parameterizedType + ".");
            valueClass = (Class)((ParameterizedType)valueType).getRawType();
        }
        Constructor<T> constructor = null;
        if (mapClass.isInterface() || Modifier.isAbstract(mapClass.getModifiers())) {
            Class<T> impl = null;
            try {
                impl = HashMap.class.asSubclass(mapClass);
            }
            catch (ClassCastException e1) {
                try {
                    impl = LinkedHashMap.class.asSubclass(mapClass);
                }
                catch (ClassCastException e2) {
                    try {
                        impl = Hashtable.class.asSubclass(mapClass);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            if (impl != null) {
                constructor = ObjectBuilder.getConstructor(impl, Map.class);
            }
        } else {
            constructor = ObjectBuilder.getConstructor(mapClass, Map.class);
        }
        if (constructor == null) {
            throw new JsonException("Can't find satisfied constructor for : " + mapClass);
        }
        JsonUtils.Types jsonValueType = JsonUtils.getType(valueClass);
        HashMap<String, Object> sourceMap = new HashMap<String, Object>(jsonObject.size());
        Iterator<String> keys = jsonObject.getKeys();
        while (keys.hasNext()) {
            String k = keys.next();
            JsonValue v = jsonObject.getElement(k);
            if (jsonValueType == null) {
                sourceMap.put(k, ObjectBuilder.createObject(valueClass, v));
                continue;
            }
            switch (jsonValueType) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case CHAR: 
                case STRING: 
                case NULL: 
                case ARRAY_BYTE: 
                case ARRAY_SHORT: 
                case ARRAY_INT: 
                case ARRAY_LONG: 
                case ARRAY_FLOAT: 
                case ARRAY_DOUBLE: 
                case ARRAY_BOOLEAN: 
                case ARRAY_CHAR: 
                case ARRAY_STRING: 
                case CLASS: {
                    sourceMap.put(k, ObjectBuilder.createObjectKnownTypes(valueClass, v));
                    break;
                }
                case ARRAY_OBJECT: {
                    sourceMap.put(k, ObjectBuilder.createArray(valueClass, v));
                    break;
                }
                case COLLECTION: {
                    sourceMap.put(k, ObjectBuilder.createCollection(valueClass, valueType, v));
                    break;
                }
                case MAP: {
                    sourceMap.put(k, ObjectBuilder.createObject(valueClass, valueType, v));
                    break;
                }
                case ENUM: {
                    sourceMap.put(k, ObjectBuilder.createEnum(valueClass, v));
                }
            }
        }
        try {
            map = (Map)constructor.newInstance(sourceMap);
            return (T)map;
        }
        catch (Exception e) {
            throw new JsonException(e.getMessage(), e);
        }
    }

    public static <T> T createObject(Class<T> clazz, JsonValue jsonValue) throws JsonException {
        T object;
        if (jsonValue == null || jsonValue.isNull()) {
            return null;
        }
        JsonUtils.Types type = JsonUtils.getType(clazz);
        if (type == JsonUtils.Types.ENUM) {
            return (T)ObjectBuilder.createEnum(clazz, jsonValue);
        }
        if (!jsonValue.isObject()) {
            throw new JsonException("Unsupported type of jsonValue. ");
        }
        if (clazz.isInterface()) {
            object = JsonUtils.createProxy(clazz);
        } else {
            Constructor<T> constructor = ObjectBuilder.getConstructor(clazz, new Class[0]);
            if (constructor == null) {
                throw new JsonException("Can't find satisfied constructor for : " + clazz);
            }
            try {
                object = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new JsonException("Unable instantiate object. " + e.getMessage(), e);
            }
        }
        JsonMethod[] methods = ObjectBuilder.getJsonMethods(clazz);
        if (methods != null && methods.length > 0) {
            for (JsonMethod setMethod : methods) {
                JsonValue childJsonValue = jsonValue.getElement(setMethod.field);
                if (childJsonValue == null) continue;
                try {
                    Class<?> paramClass = setMethod.method.getParameterTypes()[0];
                    if (JsonUtils.isKnownType(paramClass)) {
                        setMethod.method.invoke(object, ObjectBuilder.createObjectKnownTypes(paramClass, childJsonValue));
                        continue;
                    }
                    JsonUtils.Types parameterType = JsonUtils.getType(paramClass);
                    if (parameterType != null) {
                        if (parameterType == JsonUtils.Types.ENUM) {
                            setMethod.method.invoke(object, ObjectBuilder.createEnum(paramClass, childJsonValue));
                            continue;
                        }
                        if (parameterType == JsonUtils.Types.ARRAY_OBJECT) {
                            setMethod.method.invoke(object, ObjectBuilder.createArray(paramClass, childJsonValue));
                            continue;
                        }
                        if (parameterType == JsonUtils.Types.COLLECTION) {
                            setMethod.method.invoke(object, ObjectBuilder.createCollection(paramClass, setMethod.method.getGenericParameterTypes()[0], childJsonValue));
                            continue;
                        }
                        if (parameterType == JsonUtils.Types.MAP) {
                            setMethod.method.invoke(object, ObjectBuilder.createObject(paramClass, setMethod.method.getGenericParameterTypes()[0], childJsonValue));
                            continue;
                        }
                        throw new JsonException("Can't restore parameter of method : " + clazz.getName() + "#" + setMethod.method.getName() + " from JSON source.");
                    }
                    setMethod.method.invoke(object, ObjectBuilder.createObject(paramClass, childJsonValue));
                }
                catch (Exception e) {
                    String msg = "Unable restore parameter via method " + clazz.getName() + "#" + setMethod.method.getName() + ". ";
                    Throwable error = e;
                    if (error instanceof JsonException) {
                        StringBuilder b = new StringBuilder(msg);
                        int indent = 4;
                        do {
                            b.append('\n');
                            for (int i = 0; i < indent; ++i) {
                                b.append(' ');
                            }
                            indent += 4;
                            b.append(e.getMessage());
                        } while ((error = error.getCause()) instanceof JsonException);
                        throw new JsonException(b.toString(), e);
                    }
                    throw new JsonException(msg + e.toString(), e);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonMethod[] getJsonMethods(Class<?> clazz) {
        HelperCache<Class<?>, JsonMethod[]> partition;
        HelperCache<Class<?>, JsonMethod[]> helperCache = partition = methodsCache[clazz.hashCode() & 7];
        synchronized (helperCache) {
            JsonMethod[] methods = partition.get(clazz);
            if (methods == null) {
                Set<String> transientFieldNames = JsonUtils.getTransientFields(clazz);
                ArrayList<JsonMethod> result = new ArrayList<JsonMethod>();
                for (Method method : clazz.getMethods()) {
                    String field;
                    String methodName = method.getName();
                    if (SKIP_METHODS.contains(methodName) || !methodName.startsWith("set") || methodName.length() <= 3 || transientFieldNames.contains(field = methodName.length() > 4 ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : methodName.substring(3).toLowerCase()) || method.getParameterTypes().length != 1) continue;
                    result.add(new JsonMethod(method, field));
                }
                methods = result.toArray(new JsonMethod[result.size()]);
                partition.put(clazz, methods);
            }
            return methods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameters) {
        HelperCache<Class<?>, Constructor<?>> partition;
        HelperCache<Class<?>, Constructor<?>> helperCache = partition = constructorsCache[clazz.hashCode() & 7];
        synchronized (helperCache) {
            Constructor<Object> constructor = partition.get(clazz);
            if (constructor == null) {
                try {
                    constructor = clazz.getConstructor(parameters);
                    partition.put(clazz, constructor);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return constructor;
        }
    }

    private static Enum<?> createEnum(Class c, JsonValue v) {
        String json = v.getStringValue();
        if (json == null || json.isEmpty()) {
            return null;
        }
        return Enum.valueOf(c, json);
    }

    private static Object createObjectKnownTypes(Class<?> clazz, JsonValue jsonValue) throws JsonException {
        JsonUtils.Types t = JsonUtils.getType(clazz);
        switch (t) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return jsonValue.getBooleanValue();
            }
            case BYTE: {
                return jsonValue.getByteValue();
            }
            case SHORT: {
                return jsonValue.getShortValue();
            }
            case INT: {
                return jsonValue.getIntValue();
            }
            case LONG: {
                return jsonValue.getLongValue();
            }
            case FLOAT: {
                return Float.valueOf(jsonValue.getFloatValue());
            }
            case DOUBLE: {
                return jsonValue.getDoubleValue();
            }
            case CHAR: {
                return Character.valueOf(jsonValue.getStringValue().charAt(0));
            }
            case STRING: {
                return jsonValue.getStringValue();
            }
            case CLASS: {
                try {
                    return Class.forName(jsonValue.getStringValue());
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            case ARRAY_BOOLEAN: {
                boolean[] params = new boolean[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getBooleanValue();
                }
                return params;
            }
            case ARRAY_BYTE: {
                byte[] params = new byte[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getByteValue();
                }
                return params;
            }
            case ARRAY_SHORT: {
                short[] params = new short[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getShortValue();
                }
                return params;
            }
            case ARRAY_INT: {
                int[] params = new int[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getIntValue();
                }
                return params;
            }
            case ARRAY_LONG: {
                long[] params = new long[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getLongValue();
                }
                return params;
            }
            case ARRAY_FLOAT: {
                float[] params = new float[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getFloatValue();
                }
                return params;
            }
            case ARRAY_DOUBLE: {
                double[] params = new double[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getDoubleValue();
                }
                return params;
            }
            case ARRAY_CHAR: {
                char[] params = new char[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getStringValue().charAt(0);
                }
                return params;
            }
            case ARRAY_STRING: {
                String[] params = new String[jsonValue.size()];
                Iterator<JsonValue> values = jsonValue.getElements();
                int i = 0;
                while (values.hasNext()) {
                    params[i++] = values.next().getStringValue();
                }
                return params;
            }
        }
        throw new JsonException("Unknown type " + clazz.getName());
    }

    private ObjectBuilder() {
    }

    static {
        SKIP_METHODS.add("setMetaClass");
        for (int i = 0; i < 8; ++i) {
            ObjectBuilder.methodsCache[i] = new HelperCache(60000L, 50);
            ObjectBuilder.constructorsCache[i] = new HelperCache(60000L, 50);
        }
    }
}

