/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.everrest.core.impl.ContainerRequest;
import org.everrest.core.impl.InputHeadersMap;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.util.Logger;

public final class ServletContainerRequest
extends ContainerRequest {
    private static final Logger LOG = Logger.getLogger(ServletContainerRequest.class);

    public static ServletContainerRequest create(HttpServletRequest req) {
        int port;
        String host;
        URL forwardedUrl = ServletContainerRequest.getForwardedUrl(req);
        if (forwardedUrl == null) {
            host = req.getServerName();
            port = req.getServerPort();
        } else {
            host = forwardedUrl.getHost();
            port = forwardedUrl.getPort();
            if (port < 0) {
                port = forwardedUrl.getDefaultPort();
            }
            LOG.debug("Assuming forwarded URL: {}", (Object)forwardedUrl);
        }
        StringBuilder commonUriBuilder = new StringBuilder();
        String scheme = ServletContainerRequest.getScheme(req);
        commonUriBuilder.append(scheme);
        commonUriBuilder.append("://");
        commonUriBuilder.append(host);
        if (!(port < 0 || port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
            commonUriBuilder.append(':');
            commonUriBuilder.append(port);
        }
        String commonUriPrefix = commonUriBuilder.toString();
        StringBuilder baseUriBuilder = new StringBuilder(commonUriPrefix);
        baseUriBuilder.append(req.getContextPath());
        baseUriBuilder.append(req.getServletPath());
        URI baseUri = URI.create(baseUriBuilder.toString());
        StringBuilder requestUriBuilder = new StringBuilder(commonUriPrefix);
        requestUriBuilder.append(req.getRequestURI());
        String queryString = req.getQueryString();
        if (queryString != null) {
            requestUriBuilder.append('?');
            requestUriBuilder.append(queryString);
        }
        URI requestUri = URI.create(requestUriBuilder.toString());
        return new ServletContainerRequest(ServletContainerRequest.getMethod(req), requestUri, baseUri, ServletContainerRequest.getEntityStream(req), ServletContainerRequest.getHeaders(req), ServletContainerRequest.getSecurityContext(req));
    }

    private ServletContainerRequest(String method, URI requestUri, URI baseUri, InputStream entityStream, MultivaluedMap<String, String> httpHeaders, SecurityContext securityContext) {
        super(method, requestUri, baseUri, entityStream, httpHeaders, securityContext);
    }

    private static String getMethod(HttpServletRequest servletRequest) {
        return servletRequest.getMethod();
    }

    private static String getScheme(HttpServletRequest servletRequest) {
        return servletRequest.getScheme();
    }

    private static URL getForwardedUrl(HttpServletRequest servletRequest) {
        String forwardedHostAndPort = servletRequest.getHeader("X-Forwarded-Host");
        if (forwardedHostAndPort == null || forwardedHostAndPort.isEmpty()) {
            return null;
        }
        URL url = ServletContainerRequest.parseForwardedHostHeader(forwardedHostAndPort, servletRequest);
        if (url == null && LOG.isWarnEnabled()) {
            LOG.warn("Ignoring invalid X-Forwarded-Host: " + forwardedHostAndPort);
        }
        return url;
    }

    private static URL parseForwardedHostHeader(String forwardedHostAndPort, HttpServletRequest servletRequest) {
        String[] parts = forwardedHostAndPort.split(":");
        if (parts.length > 2) {
            return null;
        }
        int fwdPort = -1;
        if (parts.length == 2) {
            try {
                fwdPort = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (fwdPort < 0) {
                return null;
            }
        }
        String fwdHost = parts[0];
        String scheme = ServletContainerRequest.getScheme(servletRequest);
        try {
            return new URI(scheme, null, fwdHost, fwdPort, null, null, null).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.debug(e.getLocalizedMessage());
            return null;
        }
    }

    private static MultivaluedMap<String, String> getHeaders(HttpServletRequest servletRequest) {
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        Enumeration headerNames = servletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration e = servletRequest.getHeaders(name);
            while (e.hasMoreElements()) {
                h.add(name, e.nextElement());
            }
        }
        return new InputHeadersMap((Map<String, List<String>>)((Object)h));
    }

    private static InputStream getEntityStream(HttpServletRequest servletRequest) {
        try {
            return servletRequest.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static SecurityContext getSecurityContext(final HttpServletRequest servletRequest) {
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return servletRequest.getUserPrincipal();
            }

            public boolean isUserInRole(String role) {
                return servletRequest.isUserInRole(role);
            }

            public boolean isSecure() {
                return servletRequest.isSecure();
            }

            public String getAuthenticationScheme() {
                return servletRequest.getAuthType();
            }
        };
    }
}

