/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import org.everrest.core.ApplicationContext;
import org.everrest.core.DependencySupplier;
import org.everrest.core.GenericContainerRequest;
import org.everrest.core.GenericContainerResponse;
import org.everrest.core.InitialProperties;
import org.everrest.core.Lifecycle;
import org.everrest.core.impl.EnvironmentContext;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.LifecycleComponent;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.impl.ProviderBinder;
import org.everrest.core.impl.async.AsynchronousJobPool;
import org.everrest.core.impl.async.AsynchronousMethodInvoker;
import org.everrest.core.impl.method.DefaultMethodInvoker;
import org.everrest.core.impl.method.MethodInvokerDecoratorFactory;
import org.everrest.core.impl.method.OptionsRequestMethodInvoker;
import org.everrest.core.impl.uri.UriComponent;
import org.everrest.core.method.MethodInvoker;
import org.everrest.core.resource.GenericMethodResource;
import org.everrest.core.resource.ResourceMethodDescriptor;
import org.everrest.core.servlet.ServletContainerRequest;
import org.everrest.core.tools.SimplePrincipal;
import org.everrest.core.tools.SimpleSecurityContext;
import org.everrest.core.tools.WebApplicationDeclaredRoles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationContextImpl
implements ApplicationContext,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationContextImpl.class);
    private static ThreadLocal<ApplicationContext> current = new ThreadLocal();
    protected GenericContainerRequest request;
    protected GenericContainerResponse response;
    protected ProviderBinder providers;
    protected DependencySupplier depInjector;
    private List<String> parameterValues = new ArrayList<String>();
    private List<Object> matchedResources = new ArrayList<Object>();
    private List<String> encodedMatchedURIs = new ArrayList<String>();
    private List<String> matchedURIs = new ArrayList<String>();
    private Map<String, Object> attributes;
    private Map<String, String> properties;
    private URI absolutePath;
    private String path;
    private String encodedPath;
    private MultivaluedMap<String, String> encodedPathParameters;
    private MultivaluedMap<String, String> pathParameters;
    private List<PathSegment> encodedPathSegments;
    private List<PathSegment> pathSegments;
    private MultivaluedMap<String, String> encodedQueryParameters;
    private MultivaluedMap<String, String> queryParameters;
    private SecurityContext asynchronousSecurityContext;
    private Application application;
    private EverrestConfiguration config;
    private final MethodInvokerDecoratorFactory methodInvokerDecoratorFactory;

    public static ApplicationContext getCurrent() {
        return current.get();
    }

    public static void setCurrent(ApplicationContext context) {
        current.set(context);
    }

    public ApplicationContextImpl(GenericContainerRequest request, GenericContainerResponse response, ProviderBinder providers) {
        this(request, response, providers, null);
    }

    public ApplicationContextImpl(GenericContainerRequest request, GenericContainerResponse response, ProviderBinder providers, MethodInvokerDecoratorFactory methodInvokerDecoratorFactory) {
        this.request = request;
        this.response = response;
        this.providers = providers;
        this.methodInvokerDecoratorFactory = methodInvokerDecoratorFactory;
    }

    @Override
    public void addMatchedResource(Object resource) {
        this.matchedResources.add(0, resource);
    }

    @Override
    public void addMatchedURI(String uri) {
        this.encodedMatchedURIs.add(0, uri);
        this.matchedURIs.add(0, UriComponent.decode(uri, 4));
    }

    public URI getAbsolutePath() {
        if (this.absolutePath != null) {
            return this.absolutePath;
        }
        this.absolutePath = this.getRequestUriBuilder().replaceQuery(null).fragment(null).build(new Object[0]);
        return this.absolutePath;
    }

    public UriBuilder getAbsolutePathBuilder() {
        return UriBuilder.fromUri((URI)this.getAbsolutePath());
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes == null ? (this.attributes = new HashMap<String, Object>()) : this.attributes;
    }

    public URI getBaseUri() {
        return this.request.getBaseUri();
    }

    public UriBuilder getBaseUriBuilder() {
        return UriBuilder.fromUri((URI)this.getBaseUri());
    }

    @Override
    public GenericContainerRequest getContainerRequest() {
        return this.request;
    }

    @Override
    public GenericContainerResponse getContainerResponse() {
        return this.response;
    }

    @Override
    public DependencySupplier getDependencySupplier() {
        return this.depInjector;
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.request;
    }

    @Override
    public InitialProperties getInitialProperties() {
        return this;
    }

    public List<Object> getMatchedResources() {
        return this.matchedResources;
    }

    public URI resolve(URI uri) {
        return this.getBaseUri().resolve(uri);
    }

    public URI relativize(URI uri) {
        URI requestUri = this.getRequestUri();
        return requestUri.relativize(uri);
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        return decode ? this.matchedURIs : this.encodedMatchedURIs;
    }

    @Override
    public MethodInvoker getMethodInvoker(GenericMethodResource methodDescriptor) {
        String method = this.request.getMethod();
        if ("OPTIONS".equals(method) && methodDescriptor.getMethod() == null) {
            return new OptionsRequestMethodInvoker();
        }
        DefaultMethodInvoker invoker = null;
        if (this.isAsynchronous() && methodDescriptor instanceof ResourceMethodDescriptor) {
            ContextResolver<AsynchronousJobPool> asyncJobsResolver = this.getProviders().getContextResolver(AsynchronousJobPool.class, null);
            if (asyncJobsResolver == null) {
                throw new IllegalStateException("Asynchronous jobs feature is not configured properly. ");
            }
            invoker = new AsynchronousMethodInvoker((AsynchronousJobPool)asyncJobsResolver.getContext(null));
        }
        if (invoker == null) {
            invoker = new DefaultMethodInvoker();
        }
        if (this.methodInvokerDecoratorFactory != null) {
            return this.methodInvokerDecoratorFactory.makeDecorator(invoker);
        }
        return invoker;
    }

    @Override
    public List<String> getParameterValues() {
        return this.parameterValues;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        if (this.encodedPath == null) {
            this.encodedPath = this.getAbsolutePath().getRawPath().substring(this.getBaseUri().getRawPath().length());
        }
        if (decode) {
            if (this.path != null) {
                return this.path;
            }
            this.path = UriComponent.decode(this.encodedPath, 5);
            return this.path;
        }
        return this.encodedPath;
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        if (this.encodedPathParameters == null) {
            throw new IllegalStateException("Path template variables not initialized yet.");
        }
        if (decode) {
            if (this.pathParameters == null) {
                this.pathParameters = new MultivaluedMapImpl();
            }
            if (this.pathParameters.size() != this.encodedPathParameters.size()) {
                for (String key : this.encodedPathParameters.keySet()) {
                    if (this.pathParameters.containsKey((Object)key)) continue;
                    this.pathParameters.putSingle((Object)UriComponent.decode(key, 4), (Object)UriComponent.decode((String)this.encodedPathParameters.getFirst((Object)key), 5));
                }
            }
            return this.pathParameters;
        }
        return this.encodedPathParameters;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        if (decode) {
            return this.pathSegments != null ? this.pathSegments : (this.pathSegments = UriComponent.parsePathSegments(this.getPath(), true));
        }
        return this.encodedPathSegments != null ? this.encodedPathSegments : (this.encodedPathSegments = UriComponent.parsePathSegments(this.getPath(), false));
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties == null ? (this.properties = new HashMap<String, String>()) : this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.getProperties().get(name);
    }

    @Override
    public ProviderBinder getProviders() {
        return this.providers;
    }

    @Override
    public void setProviders(ProviderBinder providers) {
        this.providers = providers;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        if (decode) {
            return this.queryParameters != null ? this.queryParameters : (this.queryParameters = UriComponent.parseQueryString(this.getRequestUri().getRawQuery(), true));
        }
        return this.encodedQueryParameters != null ? this.encodedQueryParameters : (this.encodedQueryParameters = UriComponent.parseQueryString(this.getRequestUri().getRawQuery(), false));
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    public URI getRequestUri() {
        return this.request.getRequestUri();
    }

    public UriBuilder getRequestUriBuilder() {
        return UriBuilder.fromUri((URI)this.getRequestUri());
    }

    @Override
    public SecurityContext getSecurityContext() {
        if (this.isAsynchronous() && this.request instanceof ServletContainerRequest) {
            if (this.asynchronousSecurityContext == null) {
                Principal requestPrincipal = this.request.getUserPrincipal();
                if (requestPrincipal == null) {
                    this.asynchronousSecurityContext = new SimpleSecurityContext(this.request.isSecure());
                } else {
                    WebApplicationDeclaredRoles declaredRoles = (WebApplicationDeclaredRoles)EnvironmentContext.getCurrent().get(WebApplicationDeclaredRoles.class);
                    if (declaredRoles == null) {
                        this.asynchronousSecurityContext = new SimpleSecurityContext(new SimplePrincipal(requestPrincipal.getName()), null, this.request.getAuthenticationScheme(), this.request.isSecure());
                    } else {
                        LinkedHashSet<String> userRoles = new LinkedHashSet<String>();
                        for (String declaredRole : declaredRoles.getDeclaredRoles()) {
                            if (!this.request.isUserInRole(declaredRole)) continue;
                            userRoles.add(declaredRole);
                        }
                        this.asynchronousSecurityContext = new SimpleSecurityContext(new SimplePrincipal(requestPrincipal.getName()), userRoles, this.request.getAuthenticationScheme(), this.request.isSecure());
                    }
                }
            }
            return this.asynchronousSecurityContext;
        }
        return this.request;
    }

    @Override
    public UriInfo getUriInfo() {
        return this;
    }

    @Override
    public void setDependencySupplier(DependencySupplier depInjector) {
        this.depInjector = depInjector;
    }

    @Override
    public void setParameterNames(List<String> parameterNames) {
        if (this.encodedPathParameters == null) {
            this.encodedPathParameters = new MultivaluedMapImpl();
        }
        for (int i = 0; i < parameterNames.size(); ++i) {
            this.encodedPathParameters.add((Object)parameterNames.get(i), (Object)this.parameterValues.get(i));
        }
    }

    @Override
    public void setProperty(String name, String value) {
        this.getProperties().put(name, value);
    }

    @Override
    public boolean isAsynchronous() {
        return Boolean.parseBoolean((String)this.getQueryParameters().getFirst((Object)"async")) || Boolean.parseBoolean((String)this.request.getRequestHeaders().getFirst((Object)"x-everrest-async"));
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    @Override
    public EverrestConfiguration getEverrestConfiguration() {
        return this.config == null ? (this.config = new EverrestConfiguration()) : this.config;
    }

    public void setEverrestConfiguration(EverrestConfiguration config) {
        this.config = config;
    }

    @Override
    public final void start() {
    }

    @Override
    public final void stop() {
        List perRequest = (List)this.getAttributes().get("org.everrest.lifecycle.PerRequest");
        if (perRequest != null && perRequest.size() > 0) {
            for (LifecycleComponent c : perRequest) {
                try {
                    c.destroy();
                }
                catch (InternalException e) {
                    LOG.error("Unable to destroy component. ", (Throwable)e);
                }
            }
            perRequest.clear();
        }
    }
}

