/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.impl.ApplicationContextImpl;
import org.everrest.core.impl.provider.IOHelper;
import org.everrest.core.provider.EntityProvider;

@Provider
public class InputStreamEntityProvider
implements EntityProvider<InputStream> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == InputStream.class;
    }

    public InputStream readFrom(Class<InputStream> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ApplicationContext context = ApplicationContextImpl.getCurrent();
        if (context.isAsynchronous()) {
            int bufferSize = context.getEverrestConfiguration().getMaxBufferSize();
            return IOHelper.bufferStream(entityStream, bufferSize);
        }
        return entityStream;
    }

    public long getSize(InputStream t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return InputStream.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(InputStream t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            IOHelper.write(t, entityStream);
        }
        finally {
            t.close();
        }
    }
}

