/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.uri;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.ext.RuntimeDelegate;

public class LinkBuilderImpl
implements Link.Builder {
    private URI baseUri;
    private UriBuilder uriBuilder;
    private Map<String, String> params = new HashMap<String, String>();

    public Link.Builder link(Link link) {
        this.uriBuilder = UriBuilder.fromUri((URI)link.getUri());
        this.params.clear();
        this.params.putAll(link.getParams());
        return this;
    }

    public Link.Builder link(String link) {
        return this.link(LinkImpl.valueOf((String)link));
    }

    public Link.Builder uriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder.clone();
        return this;
    }

    public Link.Builder uri(URI uri) {
        this.uriBuilder = UriBuilder.fromUri((URI)uri);
        return this;
    }

    public Link.Builder uri(String uri) throws IllegalArgumentException {
        this.uriBuilder = UriBuilder.fromUri((String)uri);
        return this;
    }

    public Link.Builder rel(String rel) {
        if (rel == null) {
            throw new IllegalArgumentException("Null rel isn't allowed");
        }
        String value = this.params.get("rel");
        if (value == null) {
            this.param("rel", rel);
        } else {
            this.param("rel", value + ' ' + rel);
        }
        return this;
    }

    public Link.Builder title(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Null title isn't allowed");
        }
        this.param("title", title);
        return this;
    }

    public Link.Builder type(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type isn't allowed");
        }
        this.param("type", type);
        return this;
    }

    public Link.Builder param(String name, String value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Null name of parameter isn't allowed");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value of parameter isn't allowed");
        }
        this.params.put(name, value);
        return this;
    }

    public Link build(Object ... values) throws UriBuilderException {
        if (values == null) {
            throw new IllegalArgumentException("Null values aren't allowed");
        }
        if (values.length > 0 && this.uriBuilder == null) {
            throw new UriBuilderException("Can't construct URI. UriBuilder isn't defined.");
        }
        URI myUri = this.uriBuilder == null ? URI.create("") : this.uriBuilder.build(values);
        return new LinkImpl(myUri).withParams(this.params);
    }

    public Link buildRelativized(URI uri, Object ... values) {
        if (uri == null) {
            throw new IllegalArgumentException("Null uri isn't allowed");
        }
        if (values == null) {
            throw new IllegalArgumentException("Null values aren't allowed");
        }
        if (values.length > 0 && this.uriBuilder == null) {
            throw new UriBuilderException("Can't construct URI. UriBuilder isn't defined.");
        }
        URI myUri = this.uriBuilder == null ? URI.create("") : (this.baseUri != null ? this.baseUri.resolve(this.uriBuilder.build(values)) : this.uriBuilder.build(values));
        return new LinkImpl(uri.relativize(myUri)).withParams(this.params);
    }

    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }

    public static class LinkImpl
    extends Link {
        private static final RuntimeDelegate.HeaderDelegate<Link> DELEGATE = RuntimeDelegate.getInstance().createHeaderDelegate(Link.class);
        private URI uri;
        private Map<String, String> params;

        LinkImpl(URI uri) {
            this.uri = uri;
            this.params = new HashMap<String, String>();
        }

        public URI getUri() {
            return this.uri;
        }

        public UriBuilder getUriBuilder() {
            return UriBuilder.fromUri((URI)this.uri);
        }

        public String getRel() {
            return this.params.get("rel");
        }

        public List<String> getRels() {
            String rel = this.getRel();
            if (rel == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(rel.split("\\s+"));
        }

        public String getTitle() {
            return this.params.get("title");
        }

        public String getType() {
            return this.params.get("type");
        }

        public Map<String, String> getParams() {
            return Collections.unmodifiableMap(this.params);
        }

        public String toString() {
            return DELEGATE.toString();
        }

        Link withParams(Map<String, String> params) {
            this.params.putAll(params);
            return this;
        }
    }
}

