/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.everrest.core.ApplicationContext;
import org.everrest.core.ConstructorDescriptor;
import org.everrest.core.ConstructorParameter;
import org.everrest.core.DependencySupplier;
import org.everrest.core.impl.ConstructorParameterImpl;
import org.everrest.core.impl.InternalException;
import org.everrest.core.impl.method.ParameterHelper;
import org.everrest.core.impl.method.ParameterResolver;
import org.everrest.core.impl.method.ParameterResolverFactory;
import org.everrest.core.resource.ResourceDescriptorVisitor;
import org.everrest.core.util.Tracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructorDescriptorImpl
implements ConstructorDescriptor {
    private static final Logger LOG = LoggerFactory.getLogger(ConstructorDescriptorImpl.class);
    public static final Comparator<ConstructorDescriptor> CONSTRUCTOR_COMPARATOR = new ConstructorComparator();
    private final Constructor<?> constructor;
    private final List<ConstructorParameter> parameters;
    private final Class<?> resourceClass;

    public ConstructorDescriptorImpl(Class<?> resourceClass, Constructor<?> constructor) {
        this.resourceClass = resourceClass;
        this.constructor = constructor;
        Class<?>[] paramTypes = constructor.getParameterTypes();
        if (paramTypes.length == 0) {
            this.parameters = Collections.emptyList();
        } else {
            Type[] getParamTypes = constructor.getGenericParameterTypes();
            Annotation[][] annotations = constructor.getParameterAnnotations();
            ArrayList<ConstructorParameterImpl> params = new ArrayList<ConstructorParameterImpl>(paramTypes.length);
            boolean encodedClass = resourceClass.getAnnotation(Encoded.class) != null;
            for (int i = 0; i < paramTypes.length; ++i) {
                String defaultValue = null;
                Annotation annotation = null;
                boolean encoded = false;
                boolean provider = resourceClass.getAnnotation(Provider.class) != null;
                List<String> allowedAnnotation = provider ? ParameterHelper.PROVIDER_CONSTRUCTOR_PARAMETER_ANNOTATIONS : ParameterHelper.RESOURCE_CONSTRUCTOR_PARAMETER_ANNOTATIONS;
                for (Annotation a : annotations[i]) {
                    Class<? extends Annotation> ac = a.annotationType();
                    if (allowedAnnotation.contains(ac.getName())) {
                        if (annotation != null) {
                            throw new RuntimeException("JAX-RS annotations on one of constructor parameters are equivocality. Annotations: " + annotation + " and " + a + " can't be applied to one parameter. ");
                        }
                        annotation = a;
                        continue;
                    }
                    if (!provider && ac == Encoded.class) {
                        encoded = true;
                        continue;
                    }
                    if (!provider && ac == DefaultValue.class) {
                        defaultValue = ((DefaultValue)a).value();
                        continue;
                    }
                    LOG.debug("Constructor parameter contains unknown or not valid JAX-RS annotation " + a + ". It will be ignored. ");
                }
                ConstructorParameterImpl cp = new ConstructorParameterImpl(annotation, annotations[i], paramTypes[i], getParamTypes[i], defaultValue, encoded || encodedClass);
                params.add(cp);
            }
            this.parameters = Collections.unmodifiableList(params);
        }
    }

    @Override
    public void accept(ResourceDescriptorVisitor visitor) {
        visitor.visitConstructorInjector(this);
    }

    @Override
    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public List<ConstructorParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public Object createInstance(ApplicationContext context) {
        Object[] p = new Object[this.parameters.size()];
        int i = 0;
        for (ConstructorParameter cp : this.parameters) {
            Annotation a = cp.getAnnotation();
            if (a != null) {
                ParameterResolver pr = ParameterResolverFactory.createParameterResolver(a);
                try {
                    p[i] = pr.resolve(cp, context);
                }
                catch (Exception e) {
                    Class<? extends Annotation> ac = a.annotationType();
                    if (ac == PathParam.class || ac == QueryParam.class || ac == MatrixParam.class) {
                        throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).build());
                    }
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).build());
                }
            } else {
                DependencySupplier dependencies = context.getDependencySupplier();
                if (dependencies == null) {
                    String msg = "Can't instantiate resource " + this.resourceClass.getName() + ". DependencySupplier not found, constructor's parameter of type " + cp.getGenericType() + " could not be injected. ";
                    LOG.error(msg);
                    if (Tracer.isTracingEnabled()) {
                        Tracer.trace(msg);
                    }
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)msg).type("text/plain").build());
                }
                Object tmp = dependencies.getComponent(cp);
                if (tmp == null) {
                    String msg = "Can't instantiate resource " + this.resourceClass.getName() + ". Constructor's parameter of type " + cp.getGenericType() + " could not be injected. ";
                    LOG.error(msg);
                    if (Tracer.isTracingEnabled()) {
                        Tracer.trace(msg);
                    }
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)msg).type("text/plain").build());
                }
                p[i] = tmp;
            }
            ++i;
        }
        try {
            return this.constructor.newInstance(p);
        }
        catch (IllegalArgumentException argExc) {
            throw new InternalException(argExc);
        }
        catch (InstantiationException instExc) {
            throw new InternalException(instExc);
        }
        catch (IllegalAccessException accessExc) {
            throw new InternalException(accessExc);
        }
        catch (InvocationTargetException invExc) {
            Throwable cause = invExc.getCause();
            if (WebApplicationException.class == cause.getClass()) {
                throw (WebApplicationException)cause;
            }
            throw new InternalException(cause);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ ConstructorInjectorImpl: ");
        sb.append("constructor: " + this.getConstructor().getName() + "; ");
        for (ConstructorParameter cp : this.getParameters()) {
            sb.append(cp.toString()).append(' ');
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static class ConstructorComparator
    implements Comparator<ConstructorDescriptor> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(ConstructorDescriptor o1, ConstructorDescriptor o2) {
            int r = o2.getParameters().size() - o1.getParameters().size();
            if (r == 0) {
                LOG.debug("Two constructors with the same number of parameter found " + o1 + " and " + o2);
            }
            return r;
        }
    }
}

