/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.impl.provider.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.everrest.core.impl.MultivaluedMapImpl;
import org.everrest.core.impl.header.HeaderHelper;
import org.everrest.core.impl.provider.multipart.OutputItem;

public class BaseMultipartFormDataWriter {
    private static final Annotation[] EMPTY = new Annotation[0];
    private static final byte[] NEW_LINE = "\r\n".getBytes();
    private static final byte[] HEADER_LINE_DELIM = ": ".getBytes();
    private static final byte[] HYPHENS = "--".getBytes();
    @Context
    private Providers providers;

    public void writeItems(Collection<OutputItem> items, OutputStream output, byte[] boundary) throws IOException {
        for (OutputItem item : items) {
            this.writeItem(item, output, boundary);
        }
        output.write(HYPHENS);
        output.write(boundary);
        output.write(HYPHENS);
        output.write(NEW_LINE);
    }

    protected void writeItem(OutputItem item, OutputStream output, byte[] boundary) throws IOException {
        output.write(HYPHENS);
        output.write(boundary);
        output.write(NEW_LINE);
        MediaType mediaType = item.getMediaType();
        Class<?> type = item.getType();
        Type genericType = item.getGenericType();
        MessageBodyWriter writer = this.providers.getMessageBodyWriter(type, genericType, EMPTY, mediaType);
        if (writer == null) {
            throw new RuntimeException(String.format("Unable to find a MessageBodyWriter for media type '%s' and class '%s'", mediaType, type.getName()));
        }
        MultivaluedMapImpl myHeaders = new MultivaluedMapImpl();
        String contentDispositionHeader = "form-data; name=\"" + item.getName() + '\"';
        String filename = item.getFilename();
        if (filename != null) {
            contentDispositionHeader = contentDispositionHeader + "; filename=\"" + item.getFilename() + "\"";
        }
        myHeaders.putSingle("Content-Disposition", contentDispositionHeader);
        if (mediaType != null) {
            myHeaders.putSingle("Content-Type", mediaType.toString());
        }
        myHeaders.putAll((Map)item.getHeaders());
        this.writeHeaders(myHeaders, output);
        writer.writeTo(item.getEntity(), type, genericType, EMPTY, mediaType, (MultivaluedMap)myHeaders, output);
        output.write(NEW_LINE);
    }

    private void writeHeaders(MultivaluedMap<String, String> headers, OutputStream output) throws IOException {
        for (Map.Entry e : headers.entrySet()) {
            String name = (String)e.getKey();
            for (Object o : (List)e.getValue()) {
                String value;
                if (o == null || (value = HeaderHelper.getHeaderAsString(o)) == null) continue;
                output.write(name.getBytes());
                output.write(HEADER_LINE_DELIM);
                output.write(value.getBytes());
                output.write(NEW_LINE);
            }
        }
        output.write(NEW_LINE);
    }
}

