/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.core.servlet;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import org.everrest.core.impl.EverrestConfiguration;
import org.everrest.core.servlet.ComponentFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EverrestServletContextInitializer {
    public static final String EVERREST_SCAN_COMPONENTS = "org.everrest.scan.components";
    public static final String EVERREST_SCAN_SKIP_PACKAGES = "org.everrest.scan.skip.packages";
    public static final String JAXRS_APPLICATION = "javax.ws.rs.Application";
    private static final Logger LOG = LoggerFactory.getLogger(EverrestServletContextInitializer.class);
    protected final ServletContext ctx;

    public EverrestServletContextInitializer(ServletContext ctx) {
        this.ctx = ctx;
    }

    public Application getApplication() {
        Application application = null;
        String applicationFQN = this.getParameter(JAXRS_APPLICATION);
        boolean scan = this.getBoolean(EVERREST_SCAN_COMPONENTS, false);
        if (applicationFQN != null) {
            if (scan) {
                String msg = "Scan of JAX-RS components is disabled cause to specified 'javax.ws.rs.Application'.";
                LOG.warn(msg);
            }
            try {
                Class<?> cl = Thread.currentThread().getContextClassLoader().loadClass(applicationFQN);
                application = (Application)cl.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        } else if (scan) {
            application = new Application(){

                public Set<Class<?>> getClasses() {
                    return new LinkedHashSet(ComponentFinder.findComponents());
                }
            };
        }
        return application;
    }

    public EverrestConfiguration getConfiguration() {
        EverrestConfiguration config = new EverrestConfiguration();
        for (String parameterName : this.getParameterNames()) {
            config.setProperty(parameterName, this.getParameter(parameterName));
        }
        return config;
    }

    protected List<String> getParameterNames() {
        return Collections.list(this.ctx.getInitParameterNames());
    }

    protected String getParameter(String name) {
        String str = this.ctx.getInitParameter(name);
        if (str != null) {
            return str.trim();
        }
        return null;
    }

    protected String getParameter(String name, String def) {
        String value = this.getParameter(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    protected boolean getBoolean(String name, boolean def) {
        String str = this.getParameter(name);
        if (str != null) {
            return "true".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "on".equalsIgnoreCase(str) || "1".equals(str);
        }
        return def;
    }

    protected Double getNumber(String name, double def) {
        String str = this.getParameter(name);
        if (str != null) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }
}

