/**
 * Copyright (C) 2010 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.everrest.groovy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author <a href="mailto:andrew00x@gmail.com">Andrey Parfonov</a>
 * @version $Id: ScriptFinderFactory.java 84 2010-11-05 10:19:25Z andrew00x $
 */
public class ScriptFinderFactory
{

   private static final Map<String, ScriptFinder> all = new ConcurrentHashMap<String, ScriptFinder>();

   static
   {
      all.put("file", new FileSystemScriptFinder());
   }

   public static ScriptFinder getScriptFinder(String protocol)
   {
      return all.get(protocol);
   }

   public static void addScriptFilder(String protocol, ScriptFinder finder)
   {
      all.put(protocol, finder);
   }

   private ScriptFinderFactory()
   {
   }

}
