/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.groovy;

import groovy.lang.GroovyCodeSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import org.everrest.core.DependencySupplier;
import org.everrest.core.ObjectFactory;
import org.everrest.core.ResourceBinder;
import org.everrest.core.ResourcePublicationException;
import org.everrest.core.resource.AbstractResourceDescriptor;
import org.everrest.core.uri.UriPattern;
import org.everrest.groovy.GroovyClassLoaderProvider;
import org.everrest.groovy.ResourceId;
import org.everrest.groovy.SourceFile;
import org.everrest.groovy.SourceFolder;

public class GroovyResourcePublisher {
    protected static final String DEFAULT_CHARSET_NAME = "UTF-8";
    protected static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected final ResourceBinder binder;
    protected final Map<ResourceId, String> resources = Collections.synchronizedMap(new HashMap());
    protected final GroovyClassLoaderProvider classLoaderProvider;
    protected final DependencySupplier dependencies;
    protected final Comparator<Constructor<?>> CONSTRUCTOR_COMPARATOR = new Comparator<Constructor<?>>(){

        @Override
        public int compare(Constructor<?> o1, Constructor<?> o2) {
            int r = o2.getParameterTypes().length - o1.getParameterTypes().length;
            return r;
        }
    };

    protected GroovyResourcePublisher(ResourceBinder binder, GroovyClassLoaderProvider classLoaderProvider, DependencySupplier dependencies) {
        this.binder = binder;
        this.classLoaderProvider = classLoaderProvider;
        this.dependencies = dependencies;
    }

    public GroovyResourcePublisher(ResourceBinder binder, DependencySupplier dependencies) {
        this(binder, new GroovyClassLoaderProvider(), dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectFactory<AbstractResourceDescriptor> getResource(ResourceId resourceId) {
        List rootResources;
        String path = this.resources.get(resourceId);
        if (path == null) {
            return null;
        }
        UriPattern pattern = new UriPattern(path);
        List list = rootResources = this.binder.getResources();
        synchronized (list) {
            for (ObjectFactory res : rootResources) {
                if (!((AbstractResourceDescriptor)res.getObjectModel()).getUriPattern().equals((Object)pattern)) continue;
                return res;
            }
        }
        this.resources.remove(resourceId);
        return null;
    }

    public boolean isPublished(ResourceId resourceId) {
        return null != this.getResource(resourceId);
    }

    public void publishPerRequest(InputStream in, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        Class rc;
        try {
            rc = this.classLoaderProvider.getGroovyClassLoader(src).parseClass(in, resourceId.getId(), files);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.binder.addResource(rc, properties);
        this.resources.put(resourceId, rc.getAnnotation(Path.class).value());
    }

    public final void publishPerRequest(String source, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        this.publishPerRequest(source, DEFAULT_CHARSET, resourceId, properties, src, files);
    }

    public final void publishPerRequest(String source, String charset, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        this.publishPerRequest(source, charset == null ? DEFAULT_CHARSET : Charset.forName(charset), resourceId, properties, src, files);
    }

    public void publishSingleton(InputStream in, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        Object r;
        Class rc;
        try {
            rc = this.classLoaderProvider.getGroovyClassLoader(src).parseClass(in, resourceId.getId(), files);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            r = this.createInstance(rc);
        }
        catch (IllegalArgumentException e) {
            throw new ResourcePublicationException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new ResourcePublicationException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResourcePublicationException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ResourcePublicationException(e.getMessage());
        }
        this.binder.addResource(r, properties);
        this.resources.put(resourceId, r.getClass().getAnnotation(Path.class).value());
    }

    public final void publishSingleton(String source, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        this.publishSingleton(source, DEFAULT_CHARSET, resourceId, properties, src, files);
    }

    public final void publishSingleton(String source, String charset, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        this.publishSingleton(source, charset == null ? DEFAULT_CHARSET : Charset.forName(charset), resourceId, properties, src, files);
    }

    public ObjectFactory<AbstractResourceDescriptor> unpublishResource(ResourceId resourceId) {
        String path = this.resources.get(resourceId);
        if (path == null) {
            return null;
        }
        ObjectFactory resource = this.binder.removeResource(path);
        if (resource != null) {
            this.resources.remove(resourceId);
        }
        return resource;
    }

    private void publishPerRequest(String source, Charset charset, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        byte[] bytes = source.getBytes(charset);
        this.publishPerRequest(new ByteArrayInputStream(bytes), resourceId, properties, src, files);
    }

    private void publishSingleton(String source, Charset charset, ResourceId resourceId, MultivaluedMap<String, String> properties, SourceFolder[] src, SourceFile[] files) {
        byte[] bytes = source.getBytes(charset);
        this.publishSingleton(new ByteArrayInputStream(bytes), resourceId, properties, src, files);
    }

    protected Object createInstance(Class<?> clazz) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors = clazz.getConstructors();
        Arrays.sort(constructors, this.CONSTRUCTOR_COMPARATOR);
        block0: for (Constructor<?> c : constructors) {
            Class<?>[] parameterTypes = c.getParameterTypes();
            if (parameterTypes.length == 0) {
                return c.newInstance(new Object[0]);
            }
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object param = this.dependencies.getComponent(parameterTypes[i]);
                if (param == null) continue block0;
                parameters[i] = param;
            }
            return c.newInstance(parameters);
        }
        throw new ResourcePublicationException("Unbale create instance of class " + clazz.getName() + ". Required constructor's dependencies can't be resolved. ");
    }

    protected GroovyCodeSource createCodeSource(InputStream in, String name) {
        GroovyCodeSource gcs = new GroovyCodeSource(in, name, "/groovy/script/jaxrs");
        gcs.setCachable(false);
        return gcs;
    }
}

