/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.groovy.servlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.codehaus.groovy.control.CompilationFailedException;
import org.everrest.core.Filter;
import org.everrest.core.servlet.EverrestServletContextInitializer;
import org.everrest.core.util.Logger;
import org.everrest.groovy.DefaultGroovyResourceLoader;
import org.everrest.groovy.GroovyClassLoaderProvider;
import org.everrest.groovy.ScriptFinder;
import org.everrest.groovy.ScriptFinderFactory;
import org.everrest.groovy.SourceFile;
import org.everrest.groovy.URLFilter;

public class GroovyEverrestServletContextInitializer
extends EverrestServletContextInitializer {
    private static final Logger LOG = Logger.getLogger(GroovyEverrestServletContextInitializer.class);
    public static final String EVERREST_GROOVY_ROOT_RESOURCES = "org.everrest.groovy.root.resources";
    public static final String EVERREST_GROOVY_APPLICATION = "org.everrest.groovy.Application";
    public static final String EVERREST_GROOVY_SCAN_COMPONENTS = "org.everrest.groovy.scan.components";
    protected final GroovyClassLoaderProvider classLoaderProvider = new GroovyClassLoaderProvider();
    protected final URL[] groovyClassPath;

    public GroovyEverrestServletContextInitializer(ServletContext sctx) {
        super(sctx);
        try {
            String rootResourcesParameter = this.getParameter(EVERREST_GROOVY_ROOT_RESOURCES);
            if (rootResourcesParameter != null) {
                String[] tokens = rootResourcesParameter.split(",");
                this.groovyClassPath = new URL[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    this.groovyClassPath[i] = URI.create(tokens[i]).toURL();
                }
            } else {
                this.groovyClassPath = new URL[0];
            }
            this.classLoaderProvider.getGroovyClassLoader().setResourceLoader(new DefaultGroovyResourceLoader(this.groovyClassPath));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Application getApplication() {
        String groovyApplicationFQN = this.getParameter(EVERREST_GROOVY_APPLICATION);
        boolean scan = this.getBoolean(EVERREST_GROOVY_SCAN_COMPONENTS, false);
        Application groovyApplication = null;
        if (groovyApplicationFQN != null) {
            if (scan) {
                LOG.warn("Scan of Groovy JAX-RS components is disabled cause to specified 'org.everrest.groovy.Application'.");
            }
            try {
                Class applicationClass = this.classLoaderProvider.getGroovyClassLoader().loadClass(groovyApplicationFQN, true, false);
                groovyApplication = (Application)applicationClass.newInstance();
            }
            catch (CompilationFailedException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        if (scan) {
            try {
                final HashSet<Class> scanned = new HashSet<Class>();
                Class[] jaxrsAnnotations = new Class[]{Path.class, Provider.class, Filter.class};
                URLFilter filter = new URLFilter(){

                    @Override
                    public boolean accept(URL url) {
                        return url.getPath().endsWith(".groovy");
                    }
                };
                for (int i = 0; i < this.groovyClassPath.length; ++i) {
                    URL path = this.groovyClassPath[i];
                    String protocol = path.getProtocol();
                    ScriptFinder finder = ScriptFinderFactory.getScriptFinder(protocol);
                    if (finder != null) {
                        URL[] scripts = finder.find(filter, path);
                        if (scripts == null || scripts.length <= 0) continue;
                        SourceFile[] files = new SourceFile[scripts.length];
                        for (int k = 0; k < scripts.length; ++k) {
                            files[k] = new SourceFile(scripts[k]);
                        }
                        Class[] classes = this.classLoaderProvider.getGroovyClassLoader().parseClasses(files);
                        for (int k = 0; k < classes.length; ++k) {
                            Class clazz = classes[k];
                            if (!this.findAnnotation(clazz, jaxrsAnnotations)) continue;
                            boolean added = scanned.add(clazz);
                            if (added) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug("Add class : " + clazz);
                                continue;
                            }
                            LOG.warn("Skip duplicated class: " + clazz);
                        }
                        continue;
                    }
                    LOG.warn("Skip URL : " + path + ". Protocol '" + protocol + "' is not supported for scan JAX-RS components. ");
                }
                groovyApplication = new Application(){

                    public Set<Class<?>> getClasses() {
                        return scanned;
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return groovyApplication;
    }

    private boolean findAnnotation(Class<?> clazz, Class<? extends Annotation> ... annClasses) {
        for (Class<? extends Annotation> ac : annClasses) {
            if (clazz.getAnnotation(ac) == null) continue;
            return true;
        }
        return false;
    }
}

