/*
 * Decompiled with CFR 0.152.
 */
package org.everrest.groovy;

import java.net.MalformedURLException;
import java.net.URL;
import org.everrest.groovy.DefaultGroovyResourceLoader;
import org.everrest.groovy.ExtendedGroovyClassLoader;
import org.everrest.groovy.SourceFolder;

public class GroovyClassLoaderProvider {
    private ExtendedGroovyClassLoader defaultClassLoader;

    public GroovyClassLoaderProvider() {
        this(new ExtendedGroovyClassLoader(GroovyClassLoaderProvider.class.getClassLoader()));
    }

    protected GroovyClassLoaderProvider(ExtendedGroovyClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public ExtendedGroovyClassLoader getGroovyClassLoader() {
        return this.defaultClassLoader;
    }

    public ExtendedGroovyClassLoader getGroovyClassLoader(SourceFolder[] sources) throws MalformedURLException {
        if (sources == null || sources.length == 0) {
            return this.getGroovyClassLoader();
        }
        URL[] roots = new URL[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            roots[i] = sources[i].getPath();
        }
        ExtendedGroovyClassLoader parent = this.getGroovyClassLoader();
        ExtendedGroovyClassLoader classLoader = new ExtendedGroovyClassLoader(parent);
        classLoader.setResourceLoader(new DefaultGroovyResourceLoader(roots));
        return classLoader;
    }
}

